/*
 * Decompiled with CFR 0.152.
 */
package org.passay;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.cryptacular.bean.HashBean;
import org.passay.PasswordData;
import org.passay.SourceRule;

public class DigestSourceRule
extends SourceRule {
    private final HashBean<String> hashBean;
    private Charset charset = StandardCharsets.UTF_8;

    public DigestSourceRule(HashBean<String> bean) {
        this.hashBean = bean;
    }

    public void setCharset(Charset set) {
        if (set == null) {
            throw new NullPointerException("Character set cannot be null");
        }
        this.charset = set;
    }

    @Override
    protected boolean matches(String password, PasswordData.Reference reference) {
        PasswordData.Salt salt = reference.getSalt();
        String undigested = salt == null ? password : salt.applyTo(password);
        return this.hashBean.compare((Object)reference.getPassword(), new Object[]{undigested.getBytes(this.charset)});
    }
}

