/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.cli;

import java.io.FileReader;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.ldaptive.AddOperation;
import org.ldaptive.AddRequest;
import org.ldaptive.Connection;
import org.ldaptive.ConnectionConfig;
import org.ldaptive.ConnectionFactory;
import org.ldaptive.LdapEntry;
import org.ldaptive.SearchResult;
import org.ldaptive.cli.AbstractCli;
import org.ldaptive.io.LdifReader;
import org.ldaptive.props.BindConnectionInitializerPropertySource;
import org.ldaptive.props.ConnectionConfigPropertySource;
import org.ldaptive.props.SslConfigPropertySource;
import org.ldaptive.ssl.SslConfig;

public class AddOperationCli
extends AbstractCli {
    private static final String OPT_FILE = "file";
    private static final String COMMAND_NAME = "ldapadd";

    public static void main(String[] args) {
        AddOperationCli cli = new AddOperationCli();
        int status = cli.performAction(args);
        System.exit(status);
    }

    @Override
    protected void initOptions() {
        this.options.addOption(new Option(OPT_FILE, true, "LDIF file"));
        Map<String, String> desc = this.getArgDesc(ConnectionConfig.class, SslConfig.class);
        for (String s : ConnectionConfigPropertySource.getProperties()) {
            this.options.addOption(new Option(s, true, desc.get(s)));
        }
        for (String s : SslConfigPropertySource.getProperties()) {
            this.options.addOption(new Option(s, true, desc.get(s)));
        }
        for (String s : BindConnectionInitializerPropertySource.getProperties()) {
            this.options.addOption(new Option(s, true, desc.get(s)));
        }
        super.initOptions();
    }

    @Override
    protected int dispatch(CommandLine line) throws Exception {
        if (!line.hasOption("help")) {
            return this.add(this.initConnectionFactory(line), line.getOptionValue(OPT_FILE));
        }
        this.printHelp();
        return -1;
    }

    protected int add(ConnectionFactory cf, String file) throws Exception {
        Connection conn = cf.getConnection();
        conn.open();
        LdifReader reader = new LdifReader(new FileReader(file));
        SearchResult sr = reader.read();
        for (LdapEntry le : sr.getEntries()) {
            AddOperation op = new AddOperation(conn);
            op.execute(new AddRequest(le.getDn(), le.getAttributes()));
            System.out.println(String.format("Added entry: %s", le));
        }
        conn.close();
        return 0;
    }

    @Override
    protected String getCommandName() {
        return COMMAND_NAME;
    }
}

