/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.auth;

import java.util.Arrays;
import org.ldaptive.Connection;
import org.ldaptive.ConnectionFactory;
import org.ldaptive.ConnectionFactoryManager;
import org.ldaptive.LdapException;
import org.ldaptive.SearchOperation;
import org.ldaptive.SearchResult;
import org.ldaptive.auth.AbstractSearchEntryResolver;
import org.ldaptive.auth.AuthenticationCriteria;
import org.ldaptive.auth.AuthenticationHandlerResponse;

public class SearchEntryResolver
extends AbstractSearchEntryResolver
implements ConnectionFactoryManager {
    private ConnectionFactory factory;

    public SearchEntryResolver() {
    }

    public SearchEntryResolver(ConnectionFactory cf) {
        this.setConnectionFactory(cf);
    }

    @Override
    public ConnectionFactory getConnectionFactory() {
        return this.factory;
    }

    @Override
    public void setConnectionFactory(ConnectionFactory cf) {
        this.factory = cf;
    }

    @Override
    public SearchResult performLdapSearch(AuthenticationCriteria criteria, AuthenticationHandlerResponse response) throws LdapException {
        if (this.factory == null) {
            SearchOperation op = this.createSearchOperation(response.getConnection());
            return (SearchResult)op.execute(this.createSearchRequest(criteria)).getResult();
        }
        try (Connection factoryConn = this.factory.getConnection();){
            factoryConn.open();
            SearchOperation op = this.createSearchOperation(factoryConn);
            SearchResult searchResult = (SearchResult)op.execute(this.createSearchRequest(criteria)).getResult();
            return searchResult;
        }
    }

    public String toString() {
        return String.format("[%s@%d::factory=%s, baseDn=%s, userFilter=%s, userFilterParameters=%s, allowMultipleEntries=%s, subtreeSearch=%s, derefAliases=%s, referralHandler=%s, searchEntryHandlers=%s]", new Object[]{this.getClass().getName(), this.hashCode(), this.factory, this.getBaseDn(), this.getUserFilter(), Arrays.toString(this.getUserFilterParameters()), this.getAllowMultipleEntries(), this.getSubtreeSearch(), this.getDerefAliases(), this.getReferralHandler(), Arrays.toString(this.getSearchEntryHandlers())});
    }
}

