/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.signature.support.impl.provider;

import javax.annotation.Nonnull;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.apache.xml.security.Init;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.signature.XMLSignature;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.CredentialSupport;
import org.opensaml.xmlsec.signature.Signature;
import org.opensaml.xmlsec.signature.impl.SignatureImpl;
import org.opensaml.xmlsec.signature.support.SignatureException;
import org.opensaml.xmlsec.signature.support.SignerProvider;
import org.slf4j.Logger;

public class ApacheSantuarioSignerProviderImpl
implements SignerProvider {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(ApacheSantuarioSignerProviderImpl.class);

    @Override
    public void signObject(@Nonnull Signature signature) throws SignatureException {
        Constraint.isNotNull(signature, "Signature cannot be null");
        Constraint.isTrue(Init.isInitialized(), "Apache XML security library is not initialized");
        try {
            XMLSignature xmlSignature = ((SignatureImpl)signature).getXMLSignature();
            if (xmlSignature == null) {
                this.log.error("Unable to compute signature, Signature XMLObject does not have the XMLSignature created during marshalling");
                throw new SignatureException("XMLObject does not have XMLSignature instance, unable to compute signature");
            }
            Credential signingCred = signature.getSigningCredential();
            if (signingCred == null) {
                this.log.error("Unable to compute signature, Signature XMLObject does not contain a signing key");
                throw new SignatureException("XMLObject does not have signing key, unable to compute signature");
            }
            this.log.debug("Computing signature over XMLSignature object");
            xmlSignature.sign(CredentialSupport.extractSigningKey(signingCred));
        }
        catch (XMLSecurityException e) {
            this.log.error("An error occured computing the digital signature: {}", (Object)e.getMessage());
            throw new SignatureException("Signature computation error", (Exception)((Object)e));
        }
    }
}

