/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.core.impl;

import javax.annotation.Nonnull;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.saml.common.AbstractSAMLObjectUnmarshaller;
import org.opensaml.saml.saml2.core.Action;
import org.opensaml.saml.saml2.core.AuthzDecisionStatement;
import org.opensaml.saml.saml2.core.DecisionTypeEnumeration;
import org.opensaml.saml.saml2.core.Evidence;
import org.w3c.dom.Attr;

public class AuthzDecisionStatementUnmarshaller
extends AbstractSAMLObjectUnmarshaller {
    @Override
    protected void processChildElement(@Nonnull XMLObject parentObject, @Nonnull XMLObject childObject) throws UnmarshallingException {
        AuthzDecisionStatement authzDS = (AuthzDecisionStatement)parentObject;
        if (childObject instanceof Action) {
            authzDS.getActions().add((Action)childObject);
        } else if (childObject instanceof Evidence) {
            authzDS.setEvidence((Evidence)childObject);
        } else {
            super.processChildElement(parentObject, childObject);
        }
    }

    @Override
    protected void processAttribute(@Nonnull XMLObject xmlObject, @Nonnull Attr attribute) throws UnmarshallingException {
        AuthzDecisionStatement authzDS = (AuthzDecisionStatement)xmlObject;
        if (attribute.getNamespaceURI() == null) {
            if (attribute.getLocalName().equals("Resource")) {
                authzDS.setResource(attribute.getValue());
            } else if (attribute.getLocalName().equals("Decision")) {
                try {
                    if (attribute.getValue() == null) {
                        throw new UnmarshallingException("Saw an empty value for Decision attribute");
                    }
                    authzDS.setDecision(DecisionTypeEnumeration.valueOf(attribute.getValue().toUpperCase()));
                }
                catch (IllegalArgumentException e) {
                    throw new UnmarshallingException("Saw an invalid value for Decision attribute: " + attribute.getValue());
                }
            } else {
                super.processAttribute(xmlObject, attribute);
            }
        } else {
            super.processAttribute(xmlObject, attribute);
        }
    }
}

