/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.shared.servlet.impl;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.component.AbstractInitializableComponent;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.servlet.HttpServletRequestValidator;
import org.slf4j.Logger;

public class ChainingHttpServletRequestValidator
extends AbstractInitializableComponent
implements HttpServletRequestValidator {
    private Logger log = LoggerFactory.getLogger(ChainingHttpServletRequestValidator.class);
    @Nonnull
    private List<HttpServletRequestValidator> validators = CollectionSupport.emptyList();

    @Nonnull
    @Unmodifiable
    @NotLive
    public List<HttpServletRequestValidator> getValidators() {
        return this.validators;
    }

    public void setValidators(@Nullable List<HttpServletRequestValidator> newValidators) {
        this.checkSetterPreconditions();
        this.validators = newValidators == null ? CollectionSupport.emptyList() : newValidators.stream().filter(Objects::nonNull).collect(CollectionSupport.nonnullCollector(Collectors.toUnmodifiableList())).get();
    }

    @Override
    public void validate(@Nonnull HttpServletRequest request) throws ServletException {
        for (HttpServletRequestValidator validator : this.getValidators()) {
            try {
                validator.validate(request);
            }
            catch (ServletException e) {
                this.log.debug("Request failed validation for validator: {}", (Object)validator.getClass().getName());
                throw e;
            }
        }
    }
}

