/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.hasher;

import com.password4j.Argon2Function;
import com.password4j.HashingFunction;
import com.password4j.Password;
import com.password4j.types.Argon2;
import java.nio.CharBuffer;
import org.opensearch.security.hasher.AbstractPasswordHasher;

class Argon2PasswordHasher
extends AbstractPasswordHasher {
    private final int memory;
    private final int iterations;
    private final int length;
    private final int parallelization;
    private final Argon2 typeArgon2;
    private final int version;
    private static final int DEFAULT_SALT_LENGTH = 32;

    Argon2PasswordHasher(int memory, int iterations, int parallelism, int length, String type, int version) {
        this.iterations = iterations;
        this.memory = memory;
        this.parallelization = parallelism;
        this.length = length;
        this.typeArgon2 = this.parseType(type);
        this.version = version;
        this.hashingFunction = Argon2Function.getInstance((int)this.memory, (int)this.iterations, (int)this.parallelization, (int)this.length, (Argon2)this.typeArgon2, (int)this.version);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String hash(char[] password) {
        this.checkPasswordNotNullOrEmpty(password);
        CharBuffer passwordBuffer = CharBuffer.wrap(password);
        try {
            String string = Password.hash((CharSequence)passwordBuffer).addRandomSalt(32).with(this.hashingFunction).getResult();
            return string;
        }
        finally {
            this.cleanup(passwordBuffer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean check(char[] password, String hash) {
        this.checkPasswordNotNullOrEmpty(password);
        this.checkHashNotNullOrEmpty(hash);
        CharBuffer passwordBuffer = CharBuffer.wrap(password);
        try {
            boolean bl = Password.check((CharSequence)passwordBuffer, (String)hash).with(this.getArgon2FunctionFromHash(hash));
            return bl;
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
        finally {
            this.cleanup(passwordBuffer);
        }
    }

    private HashingFunction getArgon2FunctionFromHash(String hash) {
        return Argon2Function.getInstanceFromHash((String)hash);
    }

    private Argon2 parseType(String type) {
        if (type == null) {
            throw new IllegalArgumentException("Argon2 type can't be null");
        }
        switch (type.toUpperCase()) {
            case "ARGON2ID": {
                return Argon2.ID;
            }
            case "ARGON2I": {
                return Argon2.I;
            }
            case "ARGON2D": {
                return Argon2.D;
            }
        }
        throw new IllegalArgumentException("Unknown Argon2 type: " + type);
    }
}

