/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.dlic.rest.api;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.CheckedFunction;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.settings.Settings;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.security.dlic.rest.api.AbstractApiAction;
import org.opensearch.security.dlic.rest.api.Endpoint;
import org.opensearch.security.dlic.rest.api.RequestHandler;
import org.opensearch.security.dlic.rest.api.RestApiAdminPrivilegesEvaluator;
import org.opensearch.security.dlic.rest.api.SecurityApiDependencies;
import org.opensearch.security.dlic.rest.api.SecurityConfiguration;
import org.opensearch.security.dlic.rest.support.Utils;
import org.opensearch.security.dlic.rest.validation.EndpointValidator;
import org.opensearch.security.dlic.rest.validation.RequestContentValidator;
import org.opensearch.security.dlic.rest.validation.ValidationResult;
import org.opensearch.security.securityconf.impl.CType;
import org.opensearch.threadpool.ThreadPool;

public class SecurityConfigApiAction
extends AbstractApiAction {
    private static final List<RestHandler.Route> routes = Utils.addRoutesPrefix(List.of(new RestHandler.Route(RestRequest.Method.GET, "/securityconfig"), new RestHandler.Route(RestRequest.Method.PATCH, "/securityconfig"), new RestHandler.Route(RestRequest.Method.PUT, "/securityconfig/config")));
    private static final List<RestHandler.DeprecatedRoute> deprecatedRoutes = Utils.addLegacyRoutesPrefix((List<RestHandler.DeprecatedRoute>)ImmutableList.of((Object)new RestHandler.DeprecatedRoute(RestRequest.Method.GET, "/securityconfig", "[_opendistro/_security] is a deprecated endpoint path. Please use _plugins/_security instead."), (Object)new RestHandler.DeprecatedRoute(RestRequest.Method.PATCH, "/securityconfig", "[_opendistro/_security] is a deprecated endpoint path. Please use _plugins/_security instead."), (Object)new RestHandler.DeprecatedRoute(RestRequest.Method.PUT, "/securityconfig/config", "[_opendistro/_security] is a deprecated endpoint path. Please use _plugins/_security instead.")));
    private final boolean allowPutOrPatch;
    private final boolean restApiAdminEnabled;

    @Inject
    public SecurityConfigApiAction(ClusterService clusterService, ThreadPool threadPool, SecurityApiDependencies securityApiDependencies) {
        super(Endpoint.CONFIG, clusterService, threadPool, securityApiDependencies);
        this.allowPutOrPatch = securityApiDependencies.settings().getAsBoolean("plugins.security.unsupported.restapi.allow_securityconfig_modification", Boolean.valueOf(false));
        this.restApiAdminEnabled = securityApiDependencies.settings().getAsBoolean("plugins.security.restapi.admin.enabled", Boolean.valueOf(false));
        this.requestHandlersBuilder.configureRequestHandlers(this::securityConfigApiActionRequestHandlers);
    }

    public List<RestHandler.Route> routes() {
        return routes;
    }

    public List<RestHandler.DeprecatedRoute> deprecatedRoutes() {
        return deprecatedRoutes;
    }

    @Override
    protected CType<?> getConfigType() {
        return CType.CONFIG;
    }

    @Override
    protected void consumeParameters(RestRequest request) {
    }

    private void securityConfigApiActionRequestHandlers(RequestHandler.RequestHandlersBuilder requestHandlersBuilder) {
        requestHandlersBuilder.withAccessHandler(this::accessHandler).verifyAccessForAllMethods().onChangeRequest(RestRequest.Method.PUT, (CheckedFunction<RestRequest, ValidationResult<SecurityConfiguration>, IOException>)((CheckedFunction)request -> this.processPutRequest("config", (RestRequest)request))).onChangeRequest(RestRequest.Method.PATCH, (CheckedFunction<RestRequest, ValidationResult<SecurityConfiguration>, IOException>)((CheckedFunction)this::processPatchRequest)).override(RestRequest.Method.DELETE, RequestHandler.methodNotImplementedHandler).override(RestRequest.Method.POST, RequestHandler.methodNotImplementedHandler);
    }

    boolean accessHandler(RestRequest request) {
        switch (request.method()) {
            case PATCH: 
            case PUT: {
                if (!this.restApiAdminEnabled) {
                    return this.allowPutOrPatch;
                }
                return this.securityApiDependencies.restApiAdminPrivilegesEvaluator().isCurrentUserAdminFor(this.endpoint, "update");
            }
        }
        return true;
    }

    @Override
    protected EndpointValidator createEndpointValidator() {
        return new EndpointValidator(){

            @Override
            public Endpoint endpoint() {
                return SecurityConfigApiAction.this.endpoint;
            }

            @Override
            public RestApiAdminPrivilegesEvaluator restApiAdminPrivilegesEvaluator() {
                return SecurityConfigApiAction.this.securityApiDependencies.restApiAdminPrivilegesEvaluator();
            }

            @Override
            public RequestContentValidator createRequestContentValidator(final Object ... params) {
                return RequestContentValidator.of(new RequestContentValidator.ValidationContext(){

                    @Override
                    public Object[] params() {
                        return params;
                    }

                    @Override
                    public Settings settings() {
                        return SecurityConfigApiAction.this.securityApiDependencies.settings();
                    }

                    @Override
                    public Map<String, RequestContentValidator.DataType> allowedKeys() {
                        return ImmutableMap.of((Object)"dynamic", (Object)((Object)RequestContentValidator.DataType.OBJECT));
                    }
                });
            }
        };
    }
}

