/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.action.onbehalf;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.identity.tokens.OnBehalfOfClaims;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.BytesRestResponse;
import org.opensearch.rest.NamedRoute;
import org.opensearch.rest.RestChannel;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.RestResponse;
import org.opensearch.security.authtoken.jwt.ExpiringBearerAuthToken;
import org.opensearch.security.dlic.rest.support.Utils;
import org.opensearch.security.identity.SecurityTokenManager;
import org.opensearch.transport.client.node.NodeClient;

public class CreateOnBehalfOfTokenAction
extends BaseRestHandler {
    private static final List<RestHandler.Route> routes = Utils.addRoutesPrefix((List<RestHandler.Route>)ImmutableList.of((Object)new NamedRoute.Builder().method(RestRequest.Method.POST).path("/generateonbehalfoftoken").uniqueName("security:obo/create").build()), "/_plugins/_security/api");
    public static final long OBO_DEFAULT_EXPIRY_SECONDS = 300L;
    public static final long OBO_MAX_EXPIRY_SECONDS = 600L;
    public static final String DEFAULT_SERVICE = "self-issued";
    private static final Logger LOG = LogManager.getLogger(CreateOnBehalfOfTokenAction.class);
    private final SecurityTokenManager securityTokenManager;

    public CreateOnBehalfOfTokenAction(SecurityTokenManager securityTokenManager) {
        this.securityTokenManager = securityTokenManager;
    }

    public String getName() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }

    public List<RestHandler.Route> routes() {
        return routes;
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        switch (request.method()) {
            case POST: {
                return this.handlePost(request, client);
            }
        }
        throw new IllegalArgumentException(String.valueOf(request.method()) + " not supported");
    }

    private BaseRestHandler.RestChannelConsumer handlePost(final RestRequest request, NodeClient client) throws IOException {
        return new BaseRestHandler.RestChannelConsumer(){

            public void accept(RestChannel channel) throws Exception {
                BytesRestResponse response;
                XContentBuilder builder = channel.newBuilder();
                try {
                    if (!CreateOnBehalfOfTokenAction.this.securityTokenManager.issueOnBehalfOfTokenAllowed()) {
                        channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.BAD_REQUEST, "The OnBehalfOf token generating API has been disabled, see {link to doc} for more information on this feature."));
                        return;
                    }
                    Map requestBody = request.contentOrSourceParamParser().map();
                    CreateOnBehalfOfTokenAction.this.validateRequestParameters(requestBody);
                    long tokenDuration = CreateOnBehalfOfTokenAction.this.parseAndValidateDurationSeconds(requestBody.get(InputParameters.DURATION.paramName));
                    tokenDuration = Math.min(tokenDuration, 600L);
                    String description = requestBody.getOrDefault(InputParameters.DESCRIPTION.paramName, null);
                    String service = requestBody.getOrDefault(InputParameters.SERVICE.paramName, CreateOnBehalfOfTokenAction.DEFAULT_SERVICE);
                    ExpiringBearerAuthToken token = CreateOnBehalfOfTokenAction.this.securityTokenManager.issueOnBehalfOfToken(null, new OnBehalfOfClaims(service, Long.valueOf(tokenDuration)));
                    builder.startObject();
                    builder.field("user", token.getSubject());
                    builder.field("authenticationToken", token.getCompleteToken());
                    builder.field("durationSeconds", token.getExpiresInSeconds());
                    builder.endObject();
                    response = new BytesRestResponse(RestStatus.OK, builder);
                }
                catch (IllegalArgumentException iae) {
                    builder.startObject().field("error", iae.getMessage()).endObject();
                    response = new BytesRestResponse(RestStatus.BAD_REQUEST, builder);
                }
                catch (Exception exception) {
                    LOG.error("Unexpected error occurred: ", (Throwable)exception);
                    builder.startObject().field("error", "An unexpected error occurred. Please check the input and try again.").endObject();
                    response = new BytesRestResponse(RestStatus.INTERNAL_SERVER_ERROR, builder);
                }
                builder.close();
                channel.sendResponse((RestResponse)response);
            }
        };
    }

    private void validateRequestParameters(Map<String, Object> requestBody) throws IllegalArgumentException {
        for (String key : requestBody.keySet()) {
            Arrays.stream(InputParameters.values()).filter(param -> param.paramName.equalsIgnoreCase(key)).findAny().orElseThrow(() -> new IllegalArgumentException("Unrecognized parameter: " + key));
        }
    }

    private long parseAndValidateDurationSeconds(Object durationObj) throws IllegalArgumentException {
        if (durationObj == null) {
            return 300L;
        }
        if (durationObj instanceof Integer) {
            return ((Integer)durationObj).intValue();
        }
        if (durationObj instanceof String) {
            try {
                return Long.parseLong((String)durationObj);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        throw new IllegalArgumentException("durationSeconds must be a number.");
    }

    private static enum InputParameters {
        DURATION("durationSeconds"),
        DESCRIPTION("description"),
        SERVICE("service");

        final String paramName;

        private InputParameters(String paramName) {
            this.paramName = paramName;
        }
    }
}

