/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.server;

import java.io.Closeable;
import java.util.concurrent.atomic.AtomicReference;
import org.gradle.internal.buildprocess.BuildProcessState;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.internal.installation.CurrentGradleInstallation;
import org.gradle.internal.instrumentation.agent.AgentStatus;
import org.gradle.internal.logging.LoggingManagerInternal;
import org.gradle.internal.nativeintegration.services.NativeServices;
import org.gradle.internal.service.ServiceRegistrationProvider;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.internal.service.ServiceRegistryBuilder;
import org.gradle.launcher.daemon.configuration.DaemonServerConfiguration;
import org.gradle.launcher.daemon.registry.DaemonRegistryServices;
import org.gradle.launcher.daemon.server.DaemonServices;
import org.gradle.launcher.daemon.server.DaemonStopState;

public class DaemonProcessState
implements Closeable {
    private final BuildProcessState buildProcessState;
    private final AtomicReference<DaemonStopState> stopState = new AtomicReference();

    public DaemonProcessState(final DaemonServerConfiguration configuration, ServiceRegistry loggingServices, final LoggingManagerInternal loggingManager, ClassPath additionalModuleClassPath) {
        this.buildProcessState = new BuildProcessState(!configuration.isSingleUse(), AgentStatus.of((boolean)configuration.isInstrumentationAgentAllowed()), additionalModuleClassPath, CurrentGradleInstallation.locate(), new ServiceRegistry[]{loggingServices, NativeServices.getInstance()}){

            protected void addProviders(ServiceRegistryBuilder builder) {
                builder.provider((ServiceRegistrationProvider)new DaemonServices(configuration, loggingManager));
                builder.provider((ServiceRegistrationProvider)new DaemonRegistryServices(configuration.getBaseDir()));
            }
        };
    }

    public ServiceRegistry getServices() {
        return this.buildProcessState.getServices();
    }

    public void stopped(DaemonStopState stopState) {
        this.stopState.set(stopState);
    }

    @Override
    public void close() {
        if (this.stopState.get() == DaemonStopState.Forced) {
            return;
        }
        this.buildProcessState.close();
    }
}

