/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.vcs.internal;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.Describable;
import org.gradle.api.GradleException;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.component.ModuleComponentSelector;
import org.gradle.api.invocation.Gradle;
import org.gradle.internal.Actions;
import org.gradle.util.internal.CollectionUtils;
import org.gradle.vcs.VcsMapping;
import org.gradle.vcs.VersionControlSpec;
import org.gradle.vcs.internal.VcsMappingFactory;
import org.gradle.vcs.internal.VcsMappingInternal;
import org.gradle.vcs.internal.VcsMappingsStore;
import org.gradle.vcs.internal.VcsResolver;
import org.jspecify.annotations.Nullable;

public class DefaultVcsMappingsStore
implements VcsMappingsStore,
VcsResolver {
    private final Set<Action<? super VcsMapping>> rootVcsMappings = new LinkedHashSet<Action<? super VcsMapping>>();
    private final Map<Gradle, Set<Action<? super VcsMapping>>> vcsMappings = new HashMap<Gradle, Set<Action<? super VcsMapping>>>();
    private final VcsMappingFactory vcsMappingFactory;

    public DefaultVcsMappingsStore(VcsMappingFactory vcsMappingFactory) {
        this.vcsMappingFactory = vcsMappingFactory;
    }

    public VcsResolver asResolver() {
        return this;
    }

    public @Nullable VersionControlSpec locateVcsFor(ModuleComponentSelector selector) {
        if (!this.hasRules()) {
            return null;
        }
        VcsMappingInternal mapping = this.vcsMappingFactory.create((ComponentSelector)selector);
        this.applyTo(mapping);
        if (mapping.hasRepository()) {
            return mapping.getRepository();
        }
        return null;
    }

    private void applyTo(VcsMappingInternal mapping) {
        Actions.composite(this.rootVcsMappings).execute((Object)mapping);
        if (!mapping.hasRepository()) {
            HashSet<VersionControlSpec> resolutions = new HashSet<VersionControlSpec>();
            for (Gradle gradle : this.vcsMappings.keySet()) {
                Actions.composite((Iterable)this.vcsMappings.get(gradle)).execute((Object)mapping);
                if (!mapping.hasRepository()) continue;
                resolutions.add(mapping.getRepository());
            }
            if (resolutions.size() > 1) {
                Set resolutionDisplayNames = CollectionUtils.collect(resolutions, Describable::getDisplayName);
                throw new GradleException("Conflicting external source dependency rules were found in nested builds for " + mapping.getRequested().getDisplayName() + ":\n  " + CollectionUtils.join((String)"\n  ", (Iterable)resolutionDisplayNames));
            }
        }
    }

    public boolean hasRules() {
        return !this.vcsMappings.isEmpty() || !this.rootVcsMappings.isEmpty();
    }

    public void addRule(Action<? super VcsMapping> rule, Gradle gradle) {
        if (gradle.getParent() == null) {
            this.rootVcsMappings.add(rule);
        } else {
            if (!this.vcsMappings.containsKey(gradle)) {
                this.vcsMappings.put(gradle, new LinkedHashSet());
            }
            this.vcsMappings.get(gradle).add(rule);
        }
    }
}

