/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.execution.plan.edges;

import java.util.Set;
import org.gradle.execution.plan.Node;
import org.gradle.execution.plan.NodeSets;
import org.gradle.execution.plan.edges.DependencyNodesSet;
import org.gradle.execution.plan.edges.DependencySuccessorsOnlyNodeSet;

public class ComplexDependencyNodesSet
implements DependencyNodesSet {
    private final DependencySuccessorsOnlyNodeSet delegate;
    private final Set<Node> orderedMustSuccessors = NodeSets.newSortedNodeSet();

    public ComplexDependencyNodesSet(DependencySuccessorsOnlyNodeSet delegate) {
        this.delegate = delegate;
    }

    @Override
    public Set<Node> getDependencySuccessors() {
        return this.delegate.getDependencySuccessors();
    }

    @Override
    public DependencyNodesSet addDependency(Node toNode) {
        this.delegate.addDependency(toNode);
        return this;
    }

    @Override
    public Set<Node> getMustSuccessors() {
        return this.orderedMustSuccessors;
    }

    @Override
    public DependencyNodesSet addMustSuccessor(Node toNode) {
        this.orderedMustSuccessors.add(toNode);
        return this;
    }

    @Override
    public void onNodeComplete(Node node, Node dependency) {
        this.delegate.onNodeComplete(node, dependency);
    }

    @Override
    public Node.DependenciesState getState(Node node) {
        Node.DependenciesState state = this.delegate.getState(node);
        if (state != Node.DependenciesState.COMPLETE_AND_SUCCESSFUL) {
            return state;
        }
        for (Node dependency : this.orderedMustSuccessors) {
            if (dependency.isComplete()) continue;
            return Node.DependenciesState.NOT_COMPLETE;
        }
        return Node.DependenciesState.COMPLETE_AND_SUCCESSFUL;
    }

    @Override
    public void healthDiagnostics(StringBuilder builder) {
        this.delegate.healthDiagnostics(builder);
        if (!this.orderedMustSuccessors.isEmpty()) {
            builder.append(", must-run-after=").append(Node.formatNodes(this.orderedMustSuccessors));
        }
    }
}

