/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.collections;

import org.gradle.api.Action;
import org.gradle.api.specs.Spec;
import org.gradle.api.specs.Specs;
import org.jspecify.annotations.Nullable;

public class CollectionFilter<T>
implements Spec<Object> {
    private final Class<? extends T> type;
    private final Spec<? super T> spec;

    public CollectionFilter(Class<T> type) {
        this(type, Specs.satisfyAll());
    }

    public CollectionFilter(Class<? extends T> type, Spec<? super T> spec) {
        this.type = type;
        this.spec = spec;
    }

    public Class<? extends T> getType() {
        return this.type;
    }

    public @Nullable T filter(@Nullable Object object) {
        if (!this.type.isInstance(object)) {
            return null;
        }
        T t = this.type.cast(object);
        if (this.spec.isSatisfiedBy(t)) {
            return t;
        }
        return null;
    }

    public Action<Object> filtered(final Action<? super T> action) {
        return new Action<Object>(){

            public void execute(Object o) {
                Object t = CollectionFilter.this.filter(o);
                if (t != null) {
                    action.execute(t);
                }
            }
        };
    }

    public boolean isSatisfiedBy(Object element) {
        return this.filter(element) != null;
    }

    public <S extends T> CollectionFilter<S> and(CollectionFilter<S> other) {
        return new CollectionFilter<T>(other.type, Specs.intersect((Spec[])new Spec[]{this.spec, other.spec}));
    }
}

