/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.buildinit.plugins.internal;

import java.util.Collections;
import java.util.List;
import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.buildinit.plugins.internal.BuildInitDependency;
import org.gradle.buildinit.plugins.internal.BuildScriptBuilder;
import org.gradle.buildinit.plugins.internal.InitSettings;
import org.gradle.buildinit.plugins.internal.JvmProjectInitDescriptor;
import org.gradle.buildinit.plugins.internal.TemplateFactory;
import org.gradle.buildinit.plugins.internal.TemplateLibraryVersionProvider;
import org.gradle.buildinit.plugins.internal.model.Description;
import org.gradle.buildinit.plugins.internal.modifiers.ComponentType;

public class JvmLibraryProjectInitDescriptor
extends JvmProjectInitDescriptor {
    public JvmLibraryProjectInitDescriptor(Description description, TemplateLibraryVersionProvider libraryVersionProvider, DocumentationRegistry documentationRegistry) {
        super(description, libraryVersionProvider, documentationRegistry);
    }

    @Override
    public ComponentType getComponentType() {
        return ComponentType.LIBRARY;
    }

    @Override
    public void generateProjectBuildScript(String projectName, InitSettings settings, BuildScriptBuilder buildScriptBuilder) {
        super.generateProjectBuildScript(projectName, settings, buildScriptBuilder);
        this.applyLibraryPlugin(buildScriptBuilder);
        if (!this.isSingleProject(settings)) {
            buildScriptBuilder.plugin("Apply the java conventions plugin from build-logic.", "buildlogic.java-library-conventions");
        }
        buildScriptBuilder.dependency("api", "This dependency is exported to consumers, that is to say found on their compile classpath.", BuildInitDependency.of("org.apache.commons:commons-math3", this.libraryVersionProvider.getVersion("commons-math")));
        buildScriptBuilder.implementationDependency("This dependency is used internally, and not exposed to consumers on their own compile classpath.", BuildInitDependency.of("com.google.guava:guava", this.libraryVersionProvider.getVersion("guava")));
    }

    @Override
    protected List<String> getSourceTemplates(String subproject, InitSettings settings, TemplateFactory templateFactory) {
        return Collections.singletonList("Library");
    }

    @Override
    protected List<String> getTestSourceTemplates(String subproject, InitSettings settings, TemplateFactory templateFactory) {
        return Collections.singletonList(JvmLibraryProjectInitDescriptor.getUnitTestSourceTemplateName(settings));
    }

    private static String getUnitTestSourceTemplateName(InitSettings settings) {
        switch (settings.getTestFramework()) {
            case SPOCK: {
                return "groovy/LibraryTest";
            }
            case TESTNG: {
                return "testng/LibraryTest";
            }
            case JUNIT: 
            case KOTLINTEST: {
                return "LibraryTest";
            }
            case JUNIT_JUPITER: {
                return "junitjupiter/LibraryTest";
            }
            case SCALATEST: {
                return "LibrarySuite";
            }
        }
        throw new IllegalArgumentException();
    }
}

