/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.buildinit.plugins.internal;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import org.gradle.buildinit.plugins.internal.BuildContentGenerationContext;
import org.gradle.buildinit.plugins.internal.BuildContentGenerator;
import org.gradle.buildinit.plugins.internal.InitSettings;
import org.gradle.internal.UncheckedException;

public class GradlePropertiesGenerator
implements BuildContentGenerator {
    @Override
    public void generate(InitSettings settings, BuildContentGenerationContext buildContentGenerationContext) {
        GradlePropertiesGenerator.generate(settings);
    }

    public static void generate(InitSettings settings) {
        File file = settings.getTarget().file("gradle.properties").getAsFile();
        try (PrintWriter writer = new PrintWriter(new FileWriter(file));){
            if (settings.isWithComments()) {
                writer.println("# This file was generated by the Gradle 'init' task.");
                writer.println("# https://docs.gradle.org/current/userguide/build_environment.html#sec:gradle_configuration_properties");
                writer.println();
            }
            writer.println("org.gradle.configuration-cache=true");
            if (settings.isUseIncubatingAPIs()) {
                writer.println("org.gradle.parallel=true");
                writer.println("org.gradle.caching=true");
            }
            writer.println();
        }
        catch (IOException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
    }
}

