/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.kotlin.dsl.resolver;

import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileFilter;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import org.gradle.internal.os.OperatingSystem;
import org.gradle.kotlin.dsl.concurrent.EventLoop;
import org.gradle.kotlin.dsl.resolver.ResolverEvent;
import org.gradle.kotlin.dsl.resolver.ResolverEventLogger;
import org.gradle.kotlin.dsl.resolver.ResolverEventLoggerKt;
import org.gradle.kotlin.dsl.support.IOKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\n \u0016*\u0004\u0018\u00010\u00150\u0015H\u0002J\b\u0010\u0017\u001a\u00020\rH\u0002J\b\u0010\u0018\u001a\u00020\rH\u0002J\u0010\u0010\u0019\u001a\n \u0016*\u0004\u0018\u00010\u000b0\u000bH\u0002J\u0010\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\rH\u0002J\u001e\u0010\u001f\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\r2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00050!H\u0002J\u0018\u0010\"\u001a\n \u0016*\u0004\u0018\u00010\u000b0\u000b2\u0006\u0010#\u001a\u00020\u001bH\u0002R \u0010\b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00070\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\f\u001a\u00020\r8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u001a\u001a\u00020\u001bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020%X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lorg/gradle/kotlin/dsl/resolver/DefaultResolverEventLogger;", "Lorg/gradle/kotlin/dsl/resolver/ResolverEventLogger;", "<init>", "()V", "log", "", "event", "Lorg/gradle/kotlin/dsl/resolver/ResolverEvent;", "eventLoop", "Lorg/gradle/kotlin/dsl/concurrent/EventLoop;", "Lkotlin/Pair;", "Ljava/util/Date;", "outputFile", "Ljava/io/File;", "getOutputFile", "()Ljava/io/File;", "outputFile$delegate", "Lkotlin/Lazy;", "bufferedAppendWriter", "Ljava/io/BufferedWriter;", "timestampForFileName", "", "kotlin.jvm.PlatformType", "outputDir", "logDirForOperatingSystem", "now", "cleanupAfterDays", "", "logFilesExpireAfterDays", "cleanupLogDirectory", "logDir", "readyForCleanup", "cleanup", "Lkotlin/Function0;", "daysAgo", "days", "resolverLogFilenameRegex", "Lkotlin/text/Regex;", "kotlin-dsl"})
@SourceDebugExtension(value={"SMAP\nResolverEventLogger.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResolverEventLogger.kt\norg/gradle/kotlin/dsl/resolver/DefaultResolverEventLogger\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,256:1\n1#2:257\n13805#3,2:258\n*S KotlinDebug\n*F\n+ 1 ResolverEventLogger.kt\norg/gradle/kotlin/dsl/resolver/DefaultResolverEventLogger\n*L\n121#1:258,2\n*E\n"})
public final class DefaultResolverEventLogger
implements ResolverEventLogger {
    @NotNull
    public static final DefaultResolverEventLogger INSTANCE = new DefaultResolverEventLogger();
    @NotNull
    private static final EventLoop<Pair<Date, ResolverEvent>> eventLoop = new EventLoop(null, DefaultResolverEventLogger::eventLoop$lambda$0, 1, null);
    @NotNull
    private static final Lazy outputFile$delegate = LazyKt.lazy(DefaultResolverEventLogger::outputFile_delegate$lambda$0);
    private static final int cleanupAfterDays = 1;
    private static final int logFilesExpireAfterDays = 7;
    @NotNull
    private static final Regex resolverLogFilenameRegex = new Regex("resolver-\\d{4}-\\d{2}-\\d{2}-\\d{2}-\\d{2}-\\d{2}-\\d{3}\\.log");

    private DefaultResolverEventLogger() {
    }

    @Override
    public void log(@NotNull ResolverEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        eventLoop.accept((Pair<Date, ResolverEvent>)TuplesKt.to((Object)this.now(), (Object)event));
    }

    private final File getOutputFile() {
        Lazy lazy = outputFile$delegate;
        return (File)lazy.getValue();
    }

    private final BufferedWriter bufferedAppendWriter() {
        return new BufferedWriter(new FileWriter(this.getOutputFile(), true));
    }

    private final String timestampForFileName() {
        return new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss-SSS").format(this.now());
    }

    private final File outputDir() {
        File file;
        File $this$outputDir_u24lambda_u240 = file = this.logDirForOperatingSystem();
        boolean bl = false;
        $this$outputDir_u24lambda_u240.mkdirs();
        return file;
    }

    private final File logDirForOperatingSystem() {
        File file;
        OperatingSystem $this$logDirForOperatingSystem_u24lambda_u240 = OperatingSystem.current();
        boolean bl = false;
        if ($this$logDirForOperatingSystem_u24lambda_u240.isMacOsX()) {
            file = FilesKt.resolve((File)IOKt.userHome(), (String)"Library/Logs/gradle-kotlin-dsl");
        } else if ($this$logDirForOperatingSystem_u24lambda_u240.isWindows()) {
            String string = System.getenv("LOCALAPPDATA");
            if (string != null) {
                String it = string;
                boolean bl2 = false;
                file = new File(it + "/gradle-kotlin-dsl/log");
            } else {
                file = FilesKt.resolve((File)IOKt.userHome(), (String)"AppData/Local/gradle-kotlin-dsl/log");
            }
        } else {
            file = FilesKt.resolve((File)IOKt.userHome(), (String)".gradle-kotlin-dsl/log");
        }
        return file;
    }

    private final Date now() {
        return GregorianCalendar.getInstance().getTime();
    }

    private final void cleanupLogDirectory(File logDir) {
        this.readyForCleanup(logDir, (Function0<Unit>)((Function0)() -> DefaultResolverEventLogger.cleanupLogDirectory$lambda$0(logDir)));
    }

    private final void readyForCleanup(File logDir, Function0<Unit> cleanup) {
        File $this$readyForCleanup_u24lambda_u240 = FilesKt.resolve((File)logDir, (String)".cleanup");
        boolean bl = false;
        if (!$this$readyForCleanup_u24lambda_u240.isFile() || $this$readyForCleanup_u24lambda_u240.isFile() && new Date($this$readyForCleanup_u24lambda_u240.lastModified()).before(INSTANCE.daysAgo(1))) {
            cleanup.invoke();
            FilesKt.writeBytes((File)$this$readyForCleanup_u24lambda_u240, (byte[])new byte[0]);
        }
    }

    private final Date daysAgo(int days) {
        Calendar calendar;
        Calendar $this$daysAgo_u24lambda_u240 = calendar = GregorianCalendar.getInstance();
        boolean bl = false;
        $this$daysAgo_u24lambda_u240.add(5, -days);
        return calendar.getTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Unit eventLoop$lambda$0(Function0 poll) {
        Intrinsics.checkNotNullParameter((Object)poll, (String)"poll");
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
        Closeable closeable = INSTANCE.bufferedAppendWriter();
        Throwable throwable = null;
        try {
            BufferedWriter writer = (BufferedWriter)closeable;
            boolean bl = false;
            while ((Pair)poll.invoke() != null) {
                Pair pair;
                Date timestamp = (Date)pair.component1();
                ResolverEvent event = (ResolverEvent)pair.component2();
                DefaultResolverEventLogger.eventLoop$lambda$0$0$write(writer, format, timestamp, event);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void eventLoop$lambda$0$0$write(BufferedWriter $writer, SimpleDateFormat format, Date timestamp, ResolverEvent e) {
        try {
            $writer.write(format.format(timestamp) + " - " + ResolverEventLoggerKt.prettyPrint(e) + "\n\n");
        }
        catch (Exception e2) {
            e2.printStackTrace(new PrintWriter($writer));
        }
        finally {
            $writer.flush();
        }
    }

    private static final File outputFile_delegate$lambda$0() {
        File logDir = INSTANCE.outputDir();
        boolean bl = false;
        INSTANCE.cleanupLogDirectory(logDir);
        return FilesKt.resolve((File)logDir, (String)("resolver-" + INSTANCE.timestampForFileName() + ".log"));
    }

    private static final Unit cleanupLogDirectory$lambda$0(File $logDir) {
        Date expiration = INSTANCE.daysAgo(7);
        File[] fileArray = $logDir.listFiles(new FileFilter(expiration){
            final /* synthetic */ Date $expiration;
            {
                this.$expiration = $expiration;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean accept(File file) {
                if (!file.isFile()) return false;
                String string = file.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                CharSequence charSequence = string;
                if (!DefaultResolverEventLogger.access$getResolverLogFilenameRegex$p().matches(charSequence)) return false;
                if (!new Date(file.lastModified()).before(this.$expiration)) return false;
                return true;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)fileArray, (String)"listFiles(...)");
        Object[] $this$forEach$iv = fileArray;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File it = (File)element$iv;
            boolean bl = false;
            it.delete();
        }
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ Regex access$getResolverLogFilenameRegex$p() {
        return resolverLogFilenameRegex;
    }
}

