/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugin.devel.plugins;

import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.XmlProvider;
import org.gradle.api.component.SoftwareComponent;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.publish.PublicationContainer;
import org.gradle.api.publish.PublishingExtension;
import org.gradle.api.publish.ivy.IvyModuleDescriptorDescription;
import org.gradle.api.publish.ivy.IvyModuleDescriptorSpec;
import org.gradle.api.publish.ivy.IvyPublication;
import org.gradle.api.publish.ivy.internal.publication.IvyPublicationInternal;
import org.gradle.plugin.devel.GradlePluginDevelopmentExtension;
import org.gradle.plugin.devel.PluginDeclaration;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

abstract class IvyPluginPublishingPlugin
implements Plugin<Project> {
    @Inject
    protected abstract ProviderFactory getProviderFactory();

    @Inject
    public IvyPluginPublishingPlugin() {
    }

    public void apply(Project project) {
        project.afterEvaluate((Action)new Action<Project>(){

            public void execute(Project project) {
                IvyPluginPublishingPlugin.this.configurePublishing(project);
            }
        });
    }

    private void configurePublishing(final Project project) {
        project.getExtensions().configure(PublishingExtension.class, (Action)new Action<PublishingExtension>(){

            public void execute(PublishingExtension publishing) {
                GradlePluginDevelopmentExtension pluginDevelopment = (GradlePluginDevelopmentExtension)project.getExtensions().getByType(GradlePluginDevelopmentExtension.class);
                if (!pluginDevelopment.isAutomatedPublishing()) {
                    return;
                }
                SoftwareComponent mainComponent = (SoftwareComponent)project.getComponents().getByName("java");
                IvyPublication mainPublication = IvyPluginPublishingPlugin.this.addMainPublication(publishing, mainComponent);
                IvyPluginPublishingPlugin.this.addMarkerPublications(mainPublication, publishing, pluginDevelopment);
            }
        });
    }

    private IvyPublication addMainPublication(PublishingExtension publishing, SoftwareComponent mainComponent) {
        IvyPublication publication = (IvyPublication)publishing.getPublications().maybeCreate("pluginIvy", IvyPublication.class);
        publication.from(mainComponent);
        return publication;
    }

    private void addMarkerPublications(IvyPublication mainPublication, PublishingExtension publishing, GradlePluginDevelopmentExtension pluginDevelopment) {
        for (PluginDeclaration declaration : pluginDevelopment.getPlugins()) {
            this.createIvyMarkerPublication(declaration, mainPublication, publishing.getPublications());
        }
    }

    private void createIvyMarkerPublication(final PluginDeclaration declaration, IvyPublication mainPublication, PublicationContainer publications) {
        String pluginId = declaration.getId();
        IvyPublicationInternal publication = (IvyPublicationInternal)publications.create(declaration.getName() + "PluginMarkerIvy", IvyPublication.class);
        publication.setAlias(true);
        publication.setOrganisation(pluginId);
        publication.setModule(pluginId + ".gradle.plugin");
        final Provider organisation = this.getProviderFactory().provider(() -> ((IvyPublication)mainPublication).getOrganisation());
        final Provider module = this.getProviderFactory().provider(() -> ((IvyPublication)mainPublication).getModule());
        final Provider revision = this.getProviderFactory().provider(() -> ((IvyPublication)mainPublication).getRevision());
        publication.descriptor((Action)new Action<IvyModuleDescriptorSpec>(){

            public void execute(IvyModuleDescriptorSpec descriptor) {
                descriptor.description((Action)new Action<IvyModuleDescriptorDescription>(){

                    public void execute(IvyModuleDescriptorDescription description) {
                        description.getText().set((Object)declaration.getDescription());
                    }
                });
                descriptor.withXml((Action)new Action<XmlProvider>(){

                    public void execute(XmlProvider xmlProvider) {
                        Element root = xmlProvider.asElement();
                        Document document = root.getOwnerDocument();
                        Node dependencies = root.getElementsByTagName("dependencies").item(0);
                        Node dependency = dependencies.appendChild(document.createElement("dependency"));
                        Attr org = document.createAttribute("org");
                        org.setValue((String)organisation.get());
                        dependency.getAttributes().setNamedItem(org);
                        Attr name = document.createAttribute("name");
                        name.setValue((String)module.get());
                        dependency.getAttributes().setNamedItem(name);
                        Attr rev = document.createAttribute("rev");
                        rev.setValue((String)revision.get());
                        dependency.getAttributes().setNamedItem(rev);
                    }
                });
            }
        });
    }
}

