/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental.recomp;

import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.gradle.api.internal.tasks.compile.incremental.compilerapi.deps.DependentsSet;
import org.gradle.api.internal.tasks.compile.incremental.deps.ClassSetAnalysis;
import org.gradle.api.internal.tasks.compile.incremental.recomp.DefaultSourceFileClassNameConverter;
import org.gradle.api.internal.tasks.compile.incremental.recomp.PreviousCompilationData;
import org.gradle.api.internal.tasks.compile.incremental.recomp.SourceFileClassNameConverter;
import org.jspecify.annotations.Nullable;

public class PreviousCompilation {
    private final PreviousCompilationData data;
    private final ClassSetAnalysis classAnalysis;

    public PreviousCompilation(PreviousCompilationData data) {
        this.data = data;
        this.classAnalysis = new ClassSetAnalysis(data.getOutputSnapshot(), data.getAnnotationProcessingData(), data.getCompilerApiData());
    }

    public @Nullable ClassSetAnalysis getClasspath() {
        return new ClassSetAnalysis(this.data.getClasspathSnapshot());
    }

    public DependentsSet findDependentsOfClasspathChanges(ClassSetAnalysis.ClassSetDiff diff) {
        if (diff.getDependents().isDependencyToAll()) {
            return diff.getDependents();
        }
        return this.classAnalysis.findTransitiveDependents(diff.getDependents().getAllDependentClasses(), diff.getConstants());
    }

    public DependentsSet findDependentsOfSourceChanges(Set<String> classNames) {
        return this.classAnalysis.findTransitiveDependents(classNames, classNames.stream().collect(Collectors.toMap(Function.identity(), this.classAnalysis::getConstants)));
    }

    public DependentsSet getAnnotationProcessingDependentsSet(String className) {
        return this.classAnalysis.getAnnotationProcessingDependentsSet(className);
    }

    public Set<String> getTypesToReprocess(Set<String> compiledClasses) {
        return this.classAnalysis.getTypesToReprocess(compiledClasses);
    }

    public SourceFileClassNameConverter getSourceToClassConverter() {
        return new DefaultSourceFileClassNameConverter(this.data.getCompilerApiData().getSourceToClassMapping());
    }
}

