/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.caching;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.ConcurrentMap;
import org.gradle.caching.BuildCacheEntryReader;
import org.gradle.caching.BuildCacheEntryWriter;
import org.gradle.caching.BuildCacheException;
import org.gradle.caching.BuildCacheKey;
import org.gradle.caching.BuildCacheService;
import org.gradle.internal.io.StreamByteBuffer;

public class MapBasedBuildCacheService
implements BuildCacheService {
    private final ConcurrentMap<String, byte[]> delegate;

    public MapBasedBuildCacheService(ConcurrentMap<String, byte[]> delegate) {
        this.delegate = delegate;
    }

    public boolean load(BuildCacheKey key, BuildCacheEntryReader reader) throws BuildCacheException {
        byte[] bytes = (byte[])this.delegate.get(key.getHashCode());
        if (bytes == null) {
            return false;
        }
        try {
            reader.readFrom((InputStream)new ByteArrayInputStream(bytes));
        }
        catch (IOException e) {
            throw new BuildCacheException("loading " + key, (Throwable)e);
        }
        return true;
    }

    public void store(BuildCacheKey key, BuildCacheEntryWriter output) throws BuildCacheException {
        StreamByteBuffer buffer = new StreamByteBuffer();
        try {
            output.writeTo(buffer.getOutputStream());
        }
        catch (IOException e) {
            throw new BuildCacheException("storing " + key, (Throwable)e);
        }
        this.delegate.put(key.getHashCode(), buffer.readAsByteArray());
    }

    public void close() throws IOException {
    }
}

