/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact;

import java.util.List;
import java.util.Set;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.DependencyArtifactsVisitor;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.FileDependencyArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.VariantArtifactSetCache;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.VariantResolvingArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.specs.ExcludeSpec;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.DependencyGraphEdge;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.DependencyGraphNode;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.DependencyGraphVisitor;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.RootGraphNode;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.attributes.immutable.artifact.ImmutableArtifactTypeRegistry;
import org.gradle.internal.component.local.model.LocalFileDependencyMetadata;
import org.gradle.internal.component.model.ComponentGraphResolveState;
import org.gradle.internal.component.model.IvyArtifactName;
import org.gradle.internal.component.model.VariantGraphResolveState;
import org.gradle.internal.model.CalculatedValueContainerFactory;

public class ResolvedArtifactsGraphVisitor
implements DependencyGraphVisitor {
    private final DependencyArtifactsVisitor artifactResults;
    private final ImmutableArtifactTypeRegistry artifactTypeRegistry;
    private final VariantArtifactSetCache artifactSetCache;
    private final CalculatedValueContainerFactory calculatedValueContainerFactory;
    private int nextId;

    public ResolvedArtifactsGraphVisitor(DependencyArtifactsVisitor artifactsBuilder, ImmutableArtifactTypeRegistry artifactTypeRegistry, VariantArtifactSetCache artifactSetCache, CalculatedValueContainerFactory calculatedValueContainerFactory) {
        this.artifactResults = artifactsBuilder;
        this.artifactTypeRegistry = artifactTypeRegistry;
        this.artifactSetCache = artifactSetCache;
        this.calculatedValueContainerFactory = calculatedValueContainerFactory;
    }

    @Override
    public void visitNode(DependencyGraphNode node) {
        this.artifactResults.visitNode(node);
    }

    @Override
    public void visitEdges(DependencyGraphNode node) {
        boolean hasTransitiveIncomingEdge = this.visitNonFileEdges(node);
        if (node.isRoot() || hasTransitiveIncomingEdge) {
            for (LocalFileDependencyMetadata localFileDependencyMetadata : node.getOutgoingFileEdges()) {
                int id;
                ++this.nextId;
                this.artifactResults.visitArtifacts(node, localFileDependencyMetadata, id, (ArtifactSet)new FileDependencyArtifactSet(localFileDependencyMetadata, node.getId(), this.artifactTypeRegistry, this.calculatedValueContainerFactory));
            }
        }
    }

    private boolean visitNonFileEdges(DependencyGraphNode node) {
        boolean hasTransitiveIncomingEdge = false;
        int implicitArtifactSetId = -1;
        ArtifactSet implicitArtifactSet = null;
        for (DependencyGraphEdge dependencyGraphEdge : node.getIncomingEdges()) {
            hasTransitiveIncomingEdge |= dependencyGraphEdge.isTransitive();
            if (!dependencyGraphEdge.contributesArtifacts() || this.maybeVisitAdhocEdge(node, dependencyGraphEdge)) continue;
            if (implicitArtifactSet == null) {
                ++this.nextId;
                implicitArtifactSet = this.artifactSetCache.getImplicitVariant(node.getOwner().getResolveState(), node.getResolveState());
            }
            this.artifactResults.visitArtifacts(dependencyGraphEdge.getFrom(), node, implicitArtifactSetId, implicitArtifactSet);
        }
        return hasTransitiveIncomingEdge;
    }

    private boolean maybeVisitAdhocEdge(DependencyGraphNode node, DependencyGraphEdge dependency) {
        ComponentGraphResolveState component = node.getOwner().getResolveState();
        VariantGraphResolveState variant = node.getResolveState();
        ImmutableAttributes attributes = dependency.getAttributes();
        List<IvyArtifactName> artifacts = dependency.getDependencyMetadata().getArtifacts();
        ExcludeSpec exclusions = dependency.getExclusions();
        Set capabilitySelectors = dependency.getDependencyMetadata().getSelector().getCapabilitySelectors();
        if (artifacts.isEmpty() && attributes.isEmpty() && capabilitySelectors.isEmpty() && !exclusions.mayExcludeArtifacts()) {
            return false;
        }
        int id = this.nextId++;
        VariantResolvingArtifactSet artifactSet = new VariantResolvingArtifactSet(component, variant, attributes, artifacts, exclusions, capabilitySelectors);
        this.artifactResults.visitArtifacts(dependency.getFrom(), node, id, (ArtifactSet)artifactSet);
        return true;
    }

    @Override
    public void finish(RootGraphNode root) {
        this.artifactResults.finishArtifacts(root);
    }
}

