/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.configurations;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Set;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ExcludeRule;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.internal.DomainObjectContext;
import org.gradle.api.internal.artifacts.configurations.ConfigurationRole;
import org.gradle.api.internal.artifacts.configurations.ResolutionHost;
import org.gradle.api.internal.artifacts.configurations.ResolutionStrategyInternal;
import org.gradle.api.internal.artifacts.ivyservice.ResolutionParameters;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.internal.DisplayName;
import org.gradle.internal.deprecation.DeprecatableConfiguration;
import org.gradle.operations.dependencies.configurations.ConfigurationIdentity;
import org.jspecify.annotations.Nullable;

public interface ConfigurationInternal
extends DeprecatableConfiguration,
Configuration {
    public String getDisplayName();

    public DisplayName asDescribable();

    public AttributeContainerInternal getAttributes();

    public ResolutionStrategyInternal getResolutionStrategy();

    public void runDependencyActions();

    public void markAsObserved(String var1);

    public void markDependenciesObserved();

    public DomainObjectContext getDomainObjectContext();

    public void collectVariants(VariantVisitor var1);

    public boolean isCanBeMutated();

    public Set<ExcludeRule> getAllExcludeRules();

    public ConfigurationIdentity getConfigurationIdentity();

    public ResolutionHost getResolutionHost();

    public boolean isDetachedConfiguration();

    public ImmutableList<ResolutionParameters.ModuleVersionLock> getConsistentResolutionVersionLocks();

    public @Nullable ConfigurationInternal getConsistentResolutionSource();

    default public boolean isDeclarableByExtension() {
        return ConfigurationInternal.isDeclarableByExtension(this);
    }

    public ConfigurationRole getRoleAtCreation();

    public static boolean isDeclarableByExtension(ConfigurationInternal configuration) {
        if (configuration.isCanBeDeclared()) {
            return true;
        }
        return configuration.getExtendsFrom().stream().map(ConfigurationInternal.class::cast).anyMatch(ci -> ci.isDeclarableByExtension());
    }

    public static interface VariantVisitor {
        public void visitOwnVariant(DisplayName var1, ImmutableAttributes var2, Collection<? extends PublishArtifact> var3);

        public void visitChildVariant(String var1, DisplayName var2, ImmutableAttributes var3, Collection<? extends PublishArtifact> var4);
    }

    public static enum InternalState {
        UNRESOLVED,
        OBSERVED;

    }
}

