/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal.btree;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.gradle.cache.internal.btree.Block;
import org.gradle.cache.internal.btree.BlockPayload;
import org.gradle.cache.internal.btree.BlockPointer;
import org.gradle.cache.internal.btree.BlockStore;

public class FreeListBlockStore
implements BlockStore {
    private final BlockStore store;
    private final BlockStore freeListStore;
    private final int maxBlockEntries;
    private FreeListBlock freeListBlock;

    public FreeListBlockStore(BlockStore store, int maxBlockEntries) {
        this.store = store;
        this.freeListStore = this;
        this.maxBlockEntries = maxBlockEntries;
    }

    @Override
    public void open(final Runnable initAction, final BlockStore.Factory factory) {
        Runnable freeListInitAction = new Runnable(){

            @Override
            public void run() {
                FreeListBlockStore.this.freeListBlock = new FreeListBlock();
                FreeListBlockStore.this.store.write(FreeListBlockStore.this.freeListBlock);
                FreeListBlockStore.this.store.flush();
                initAction.run();
            }
        };
        BlockStore.Factory freeListFactory = new BlockStore.Factory(){

            @Override
            public Object create(Class<? extends BlockPayload> type) {
                if (type == FreeListBlock.class) {
                    return new FreeListBlock();
                }
                return factory.create(type);
            }
        };
        this.store.open(freeListInitAction, freeListFactory);
        this.freeListBlock = this.store.readFirst(FreeListBlock.class);
    }

    @Override
    public void close() {
        this.freeListBlock = null;
        this.store.close();
    }

    @Override
    public void clear() {
        this.store.clear();
    }

    @Override
    public void remove(BlockPayload block) {
        Block container = block.getBlock();
        this.store.remove(block);
        this.freeListBlock.add(container.getPos(), container.getSize());
    }

    @Override
    public <T extends BlockPayload> T readFirst(Class<T> payloadType) {
        return this.store.read(this.freeListBlock.getNextPos(), payloadType);
    }

    @Override
    public <T extends BlockPayload> T read(BlockPointer pos, Class<T> payloadType) {
        return this.store.read(pos, payloadType);
    }

    @Override
    public void write(BlockPayload block) {
        this.attach(block);
        this.store.write(block);
    }

    @Override
    public void attach(BlockPayload block) {
        this.store.attach(block);
        this.freeListBlock.alloc(block.getBlock());
    }

    @Override
    public void flush() {
        this.store.flush();
    }

    public class FreeListBlock
    extends BlockPayload {
        private List<FreeListEntry> entries = new ArrayList<FreeListEntry>();
        private int largestInNextBlock;
        private BlockPointer nextBlock = BlockPointer.start();
        private FreeListBlock prev;
        private FreeListBlock next;

        @Override
        protected int getSize() {
            return 16 + FreeListBlockStore.this.maxBlockEntries * 12;
        }

        @Override
        protected byte getType() {
            return 68;
        }

        @Override
        protected void read(DataInputStream inputStream) throws Exception {
            this.nextBlock = BlockPointer.pos(inputStream.readLong());
            this.largestInNextBlock = inputStream.readInt();
            int count = inputStream.readInt();
            for (int i = 0; i < count; ++i) {
                BlockPointer pos = BlockPointer.pos(inputStream.readLong());
                int size = inputStream.readInt();
                this.entries.add(new FreeListEntry(pos, size));
            }
        }

        @Override
        protected void write(DataOutputStream outputStream) throws Exception {
            outputStream.writeLong(this.nextBlock.getPos());
            outputStream.writeInt(this.largestInNextBlock);
            outputStream.writeInt(this.entries.size());
            for (FreeListEntry entry : this.entries) {
                outputStream.writeLong(entry.pos.getPos());
                outputStream.writeInt(entry.size);
            }
        }

        public void add(BlockPointer pos, int size) {
            assert (!pos.isNull() && size >= 0);
            if (size == 0) {
                return;
            }
            if (size < this.largestInNextBlock) {
                FreeListBlock next = this.getNextBlock();
                next.add(pos, size);
                return;
            }
            FreeListEntry entry = new FreeListEntry(pos, size);
            int index = Collections.binarySearch(this.entries, entry);
            if (index < 0) {
                index = -index - 1;
            }
            this.entries.add(index, entry);
            if (this.entries.size() > FreeListBlockStore.this.maxBlockEntries) {
                FreeListBlock newBlock = new FreeListBlock();
                newBlock.largestInNextBlock = this.largestInNextBlock;
                newBlock.nextBlock = this.nextBlock;
                newBlock.prev = this;
                newBlock.next = this.next;
                this.next = newBlock;
                List<FreeListEntry> newBlockEntries = this.entries.subList(0, this.entries.size() / 2);
                newBlock.entries.addAll(newBlockEntries);
                newBlockEntries.clear();
                this.largestInNextBlock = newBlock.entries.get((int)(newBlock.entries.size() - 1)).size;
                FreeListBlockStore.this.freeListStore.write(newBlock);
                this.nextBlock = newBlock.getPos();
            }
            FreeListBlockStore.this.freeListStore.write(this);
        }

        private FreeListBlock getNextBlock() {
            if (this.next == null) {
                this.next = FreeListBlockStore.this.freeListStore.read(this.nextBlock, FreeListBlock.class);
                this.next.prev = this;
            }
            return this.next;
        }

        public void alloc(Block block) {
            if (block.hasPos()) {
                return;
            }
            int requiredSize = block.getSize();
            if (this.entries.isEmpty() || requiredSize <= this.largestInNextBlock) {
                if (this.nextBlock.isNull()) {
                    return;
                }
                this.getNextBlock().alloc(block);
                return;
            }
            int index = Collections.binarySearch(this.entries, new FreeListEntry(null, requiredSize));
            if (index < 0) {
                index = -index - 1;
            }
            if (index == this.entries.size()) {
                return;
            }
            FreeListEntry entry = this.entries.remove(index);
            block.setPos(entry.pos);
            block.setSize(entry.size);
            FreeListBlockStore.this.freeListStore.write(this);
            if (this.entries.size() == 0 && this.prev != null) {
                this.prev.nextBlock = this.nextBlock;
                this.prev.largestInNextBlock = this.largestInNextBlock;
                this.prev.next = this.next;
                if (this.next != null) {
                    this.next.prev = this.prev;
                }
                FreeListBlockStore.this.freeListStore.write(this.prev);
                FreeListBlockStore.this.freeListStore.remove(this);
            }
        }
    }

    private static class FreeListEntry
    implements Comparable<FreeListEntry> {
        final BlockPointer pos;
        final int size;

        private FreeListEntry(BlockPointer pos, int size) {
            this.pos = pos;
            this.size = size;
        }

        @Override
        public int compareTo(FreeListEntry o) {
            if (this.size > o.size) {
                return 1;
            }
            if (this.size < o.size) {
                return -1;
            }
            return 0;
        }
    }
}

