/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.declarativedsl.parsing;

import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import org.gradle.internal.declarativedsl.language.SourceData;
import org.gradle.internal.declarativedsl.language.SourceIdentifier;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\r\u0018\u00002\u00020\u0001:\u0001!B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\u000e\u001a\u00020\u0005H\u0016J\b\u0010 \u001a\u00020\u0005H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u000f\u001a\u00020\t8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0010\u0010\u0011R\u001b\u0010\u0014\u001a\u00020\u00158BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0018\u0010\u0013\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0019\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0011R\u0014\u0010\u001b\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0014\u0010\u001e\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u001d\u00a8\u0006\""}, d2={"Lorg/gradle/internal/declarativedsl/parsing/LightTreeSourceData;", "Lorg/gradle/internal/declarativedsl/language/SourceData;", "sourceIdentifier", "Lorg/gradle/internal/declarativedsl/language/SourceIdentifier;", "sourceCode", "", "sourceOffset", "", "nodeRange", "Lkotlin/ranges/IntRange;", "<init>", "(Lorg/gradle/internal/declarativedsl/language/SourceIdentifier;Ljava/lang/String;ILkotlin/ranges/IntRange;)V", "getSourceIdentifier", "()Lorg/gradle/internal/declarativedsl/language/SourceIdentifier;", "toString", "indexRange", "getIndexRange", "()Lkotlin/ranges/IntRange;", "indexRange$delegate", "Lkotlin/Lazy;", "lineColumnInfo", "Lorg/gradle/internal/declarativedsl/parsing/LightTreeSourceData$LineColumnInfo;", "getLineColumnInfo", "()Lorg/gradle/internal/declarativedsl/parsing/LightTreeSourceData$LineColumnInfo;", "lineColumnInfo$delegate", "lineRange", "getLineRange", "startColumn", "getStartColumn", "()I", "endColumn", "getEndColumn", "text", "LineColumnInfo", "declarative-dsl-core"})
public final class LightTreeSourceData
implements SourceData {
    @NotNull
    private final SourceIdentifier sourceIdentifier;
    @NotNull
    private final String sourceCode;
    private final int sourceOffset;
    @NotNull
    private final IntRange nodeRange;
    @NotNull
    private final Lazy indexRange$delegate;
    @NotNull
    private final Lazy lineColumnInfo$delegate;

    public LightTreeSourceData(@NotNull SourceIdentifier sourceIdentifier, @NotNull String sourceCode, int sourceOffset, @NotNull IntRange nodeRange) {
        Intrinsics.checkNotNullParameter((Object)sourceIdentifier, (String)"sourceIdentifier");
        Intrinsics.checkNotNullParameter((Object)sourceCode, (String)"sourceCode");
        Intrinsics.checkNotNullParameter((Object)nodeRange, (String)"nodeRange");
        this.sourceIdentifier = sourceIdentifier;
        this.sourceCode = sourceCode;
        this.sourceOffset = sourceOffset;
        this.nodeRange = nodeRange;
        this.indexRange$delegate = LazyKt.lazy(() -> LightTreeSourceData.indexRange_delegate$lambda$0(this));
        this.lineColumnInfo$delegate = LazyKt.lazy(() -> LightTreeSourceData.lineColumnInfo_delegate$lambda$0(this));
    }

    @Override
    @NotNull
    public SourceIdentifier getSourceIdentifier() {
        return this.sourceIdentifier;
    }

    @NotNull
    public String toString() {
        return "LightTreeSourceData(" + this.getSourceIdentifier().getFileIdentifier() + ':' + this.nodeRange + ')';
    }

    @Override
    @NotNull
    public IntRange getIndexRange() {
        Lazy lazy = this.indexRange$delegate;
        return (IntRange)lazy.getValue();
    }

    private final LineColumnInfo getLineColumnInfo() {
        Lazy lazy = this.lineColumnInfo$delegate;
        return (LineColumnInfo)lazy.getValue();
    }

    @Override
    @NotNull
    public IntRange getLineRange() {
        return new IntRange(this.getLineColumnInfo().getStartLine(), this.getLineColumnInfo().getEndLine());
    }

    @Override
    public int getStartColumn() {
        return this.getLineColumnInfo().getStartColumn();
    }

    @Override
    public int getEndColumn() {
        return this.getLineColumnInfo().getEndColumn();
    }

    @Override
    @NotNull
    public String text() {
        return StringsKt.substring((String)this.sourceCode, (IntRange)new IntRange(this.getIndexRange().getFirst() + this.sourceOffset, this.getIndexRange().getLast() + this.sourceOffset));
    }

    private static final IntRange indexRange_delegate$lambda$0(LightTreeSourceData this$0) {
        IntRange originalRange = this$0.nodeRange;
        int first = originalRange.getFirst() - this$0.sourceOffset;
        int last = originalRange.getLast() - this$0.sourceOffset;
        return new IntRange(first, last);
    }

    private static final LineColumnInfo lineColumnInfo_delegate$lambda$0(LightTreeSourceData this$0) {
        return LineColumnInfo.Factory.fromIndexRange(this$0.sourceCode, this$0.sourceOffset, this$0.getIndexRange());
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\f\b\u0002\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\n\u00a8\u0006\u000f"}, d2={"Lorg/gradle/internal/declarativedsl/parsing/LightTreeSourceData$LineColumnInfo;", "", "startLine", "", "startColumn", "endLine", "endColumn", "<init>", "(IIII)V", "getStartLine", "()I", "getStartColumn", "getEndLine", "getEndColumn", "Factory", "declarative-dsl-core"})
    private static final class LineColumnInfo {
        @NotNull
        public static final Factory Factory = new Factory(null);
        private final int startLine;
        private final int startColumn;
        private final int endLine;
        private final int endColumn;

        public LineColumnInfo(int startLine, int startColumn, int endLine, int endColumn) {
            this.startLine = startLine;
            this.startColumn = startColumn;
            this.endLine = endLine;
            this.endColumn = endColumn;
        }

        public final int getStartLine() {
            return this.startLine;
        }

        public final int getStartColumn() {
            return this.startColumn;
        }

        public final int getEndLine() {
            return this.endLine;
        }

        public final int getEndColumn() {
            return this.endColumn;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006\f"}, d2={"Lorg/gradle/internal/declarativedsl/parsing/LightTreeSourceData$LineColumnInfo$Factory;", "", "<init>", "()V", "fromIndexRange", "Lorg/gradle/internal/declarativedsl/parsing/LightTreeSourceData$LineColumnInfo;", "text", "", "offset", "", "offsetRelativeIndexRange", "Lkotlin/ranges/IntRange;", "declarative-dsl-core"})
        public static final class Factory {
            private Factory() {
            }

            @NotNull
            public final LineColumnInfo fromIndexRange(@NotNull String text, int offset, @NotNull IntRange offsetRelativeIndexRange) {
                Intrinsics.checkNotNullParameter((Object)text, (String)"text");
                Intrinsics.checkNotNullParameter((Object)offsetRelativeIndexRange, (String)"offsetRelativeIndexRange");
                if (!org.gradle.internal.declarativedsl.parsing.LightTreeSourceData$LineColumnInfo$Factory.fromIndexRange$isValidIndex(text, offset)) {
                    throw new IllegalStateException("Check failed.");
                }
                int realStartIndex = offset + offsetRelativeIndexRange.getFirst();
                if (!org.gradle.internal.declarativedsl.parsing.LightTreeSourceData$LineColumnInfo$Factory.fromIndexRange$isValidIndex(text, realStartIndex)) {
                    throw new IllegalStateException("Check failed.");
                }
                int realEndIndex = offset + offsetRelativeIndexRange.getLast();
                if (!org.gradle.internal.declarativedsl.parsing.LightTreeSourceData$LineColumnInfo$Factory.fromIndexRange$isValidIndex(text, realEndIndex)) {
                    throw new IllegalStateException("Check failed.");
                }
                if (!(realEndIndex - realStartIndex >= -1)) {
                    throw new IllegalStateException("Check failed.");
                }
                int startLine = -1;
                int startColumn = -1;
                int endLine = -1;
                int endColumn = -1;
                int i = offset;
                int line = 1;
                int column = 1;
                while (i < text.length()) {
                    if (i == realStartIndex) {
                        startLine = line;
                        startColumn = column;
                    }
                    if (i == realEndIndex) {
                        endLine = line;
                        endColumn = column;
                        if (realStartIndex != realEndIndex + 1) break;
                        startLine = line;
                        startColumn = column + 1;
                        break;
                    }
                    int newLineLength = org.gradle.internal.declarativedsl.parsing.LightTreeSourceData$LineColumnInfo$Factory.fromIndexRange$newLineLength(text, i);
                    if (newLineLength > 0) {
                        i += newLineLength;
                        ++line;
                        column = 1;
                        continue;
                    }
                    ++i;
                    ++column;
                }
                if (!(startLine >= 0 && startColumn >= 0 && endLine >= 0 && endColumn >= 0)) {
                    throw new IllegalStateException("Check failed.");
                }
                return new LineColumnInfo(startLine, startColumn, endLine, endColumn);
            }

            private static final int fromIndexRange$newLineLength(String $this$fromIndexRange_u24newLineLength, int index) {
                int n;
                switch ($this$fromIndexRange_u24newLineLength.charAt(index)) {
                    case '\n': {
                        n = 1;
                        break;
                    }
                    case '\r': {
                        if (index + 1 < $this$fromIndexRange_u24newLineLength.length() && $this$fromIndexRange_u24newLineLength.charAt(index + 1) == '\n') {
                            n = 2;
                            break;
                        }
                        n = 1;
                        break;
                    }
                    default: {
                        n = 0;
                    }
                }
                return n;
            }

            private static final boolean fromIndexRange$isValidIndex(String $this$fromIndexRange_u24isValidIndex, int index) {
                return 0 <= index ? index < ((CharSequence)$this$fromIndexRange_u24isValidIndex).length() : false;
            }

            public /* synthetic */ Factory(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

