/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.base.internal.tasks;

import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.CheckReturnValue;
import org.gradle.internal.execution.history.OutputsCleaner;
import org.gradle.internal.file.Deleter;
import org.gradle.internal.file.FileType;

public abstract class StaleOutputCleaner {
    @CheckReturnValue
    public static boolean cleanOutputs(Deleter deleter, Iterable<File> filesToDelete, File directoryToClean) {
        return StaleOutputCleaner.cleanOutputs(deleter, filesToDelete, (ImmutableSet<File>)ImmutableSet.of((Object)directoryToClean));
    }

    @CheckReturnValue
    public static boolean cleanOutputs(Deleter deleter, Iterable<File> filesToDelete, ImmutableSet<File> directoriesToClean) {
        Set prefixes = directoriesToClean.stream().map(directoryToClean -> directoryToClean.getAbsolutePath() + File.separator).collect(Collectors.toSet());
        OutputsCleaner outputsCleaner = new OutputsCleaner(deleter, file -> {
            String absolutePath = file.getAbsolutePath();
            return prefixes.stream().anyMatch(absolutePath::startsWith);
        }, dir -> !directoriesToClean.contains(dir));
        try {
            for (File f : filesToDelete) {
                if (!f.isFile()) continue;
                outputsCleaner.cleanupOutput(f, FileType.RegularFile);
            }
            outputsCleaner.cleanupDirectories();
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to clean up stale outputs", e);
        }
        return outputsCleaner.getDidWork();
    }

    @CheckReturnValue
    public static boolean cleanEmptyOutputDirectories(Deleter deleter, Iterable<File> directories, File directoryToClean) {
        return StaleOutputCleaner.cleanEmptyOutputDirectories(deleter, directories, (Collection<File>)ImmutableSet.of((Object)directoryToClean));
    }

    @CheckReturnValue
    public static boolean cleanEmptyOutputDirectories(Deleter deleter, Iterable<File> directories, Collection<File> directoriesToClean) {
        OutputsCleaner outputsCleaner = new OutputsCleaner(deleter, file -> false, dir -> !directoriesToClean.contains(dir));
        try {
            for (File f : directories) {
                if (!f.isDirectory()) continue;
                outputsCleaner.cleanupOutput(f, FileType.Directory);
            }
            outputsCleaner.cleanupDirectories();
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to clean up stale outputs", e);
        }
        return outputsCleaner.getDidWork();
    }
}

