/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.tasks;

import java.io.File;
import java.util.List;
import javax.inject.Inject;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.IgnoreEmptyDirectories;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.WorkResult;
import org.gradle.internal.Cast;
import org.gradle.internal.operations.logging.BuildOperationLogger;
import org.gradle.internal.operations.logging.BuildOperationLoggerFactory;
import org.gradle.language.base.internal.compile.CompileSpec;
import org.gradle.language.base.internal.compile.Compiler;
import org.gradle.nativeplatform.internal.BuildOperationLoggingCompilerDecorator;
import org.gradle.nativeplatform.internal.DefaultStaticLibraryArchiverSpec;
import org.gradle.nativeplatform.internal.StaticLibraryArchiverSpec;
import org.gradle.nativeplatform.platform.NativePlatform;
import org.gradle.nativeplatform.platform.internal.NativePlatformInternal;
import org.gradle.nativeplatform.tasks.ObjectFilesToBinary;
import org.gradle.nativeplatform.toolchain.NativeToolChain;
import org.gradle.nativeplatform.toolchain.internal.NativeToolChainInternal;
import org.gradle.nativeplatform.toolchain.internal.PlatformToolProvider;
import org.gradle.work.DisableCachingByDefault;

@DisableCachingByDefault(because="Not made cacheable, yet")
public abstract class CreateStaticLibrary
extends DefaultTask
implements ObjectFilesToBinary {
    private final ConfigurableFileCollection source = this.getProject().files(new Object[0]);

    @InputFiles
    @SkipWhenEmpty
    @IgnoreEmptyDirectories
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public FileCollection getSource() {
        return this.source;
    }

    @Override
    public void source(Object source) {
        this.source.from(new Object[]{source});
    }

    @Inject
    public abstract BuildOperationLoggerFactory getOperationLoggerFactory();

    @TaskAction
    protected void link() {
        DefaultStaticLibraryArchiverSpec spec = new DefaultStaticLibraryArchiverSpec();
        spec.setTempDir(this.getTemporaryDir());
        spec.setOutputFile(((RegularFile)this.getOutputFile().get()).getAsFile());
        spec.objectFiles((Iterable<File>)this.getSource());
        spec.args((List)this.getStaticLibArgs().get());
        BuildOperationLogger operationLogger = this.getOperationLoggerFactory().newOperationLogger(this.getName(), this.getTemporaryDir());
        spec.setOperationLogger(operationLogger);
        Compiler<StaticLibraryArchiverSpec> compiler = this.createCompiler();
        WorkResult result = BuildOperationLoggingCompilerDecorator.wrap(compiler).execute((CompileSpec)spec);
        this.setDidWork(result.getDidWork());
    }

    private Compiler<StaticLibraryArchiverSpec> createCompiler() {
        NativePlatformInternal targetPlatform = (NativePlatformInternal)Cast.cast(NativePlatformInternal.class, (Object)((NativePlatform)this.getTargetPlatform().get()));
        NativeToolChainInternal toolChain = (NativeToolChainInternal)Cast.cast(NativeToolChainInternal.class, (Object)((NativeToolChain)this.getToolChain().get()));
        PlatformToolProvider toolProvider = toolChain.select(targetPlatform);
        return toolProvider.newCompiler(StaticLibraryArchiverSpec.class);
    }

    @Internal
    public abstract Property<NativeToolChain> getToolChain();

    @Nested
    public abstract Property<NativePlatform> getTargetPlatform();

    @OutputFile
    public abstract RegularFileProperty getOutputFile();

    @Internal
    public RegularFileProperty getBinaryFile() {
        return this.getOutputFile();
    }

    @Input
    public abstract ListProperty<String> getStaticLibArgs();
}

