/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.instantiation.generator;

import org.apache.commons.lang3.StringUtils;
import org.gradle.api.Describable;
import org.gradle.internal.DisplayName;
import org.gradle.internal.instantiation.InstanceGenerator;
import org.gradle.internal.instantiation.PropertyRoleAnnotationHandler;
import org.gradle.internal.instantiation.managed.ManagedObjectRegistry;
import org.gradle.internal.serialization.Cached;
import org.gradle.internal.service.ServiceLookup;
import org.gradle.internal.state.ModelObject;
import org.gradle.internal.state.OwnerAware;

public class ManagedObjectFactory {
    private final ServiceLookup serviceLookup;
    private final InstanceGenerator instantiator;
    private final PropertyRoleAnnotationHandler roleHandler;

    public ManagedObjectFactory(ServiceLookup serviceLookup, InstanceGenerator instantiator, PropertyRoleAnnotationHandler roleHandler) {
        this.serviceLookup = serviceLookup;
        this.instantiator = instantiator;
        this.roleHandler = roleHandler;
    }

    public static <T> T attachOwner(T instance, ModelObject owner, String propertyName) {
        if (instance instanceof OwnerAware) {
            ((OwnerAware)instance).attachOwner(owner, ManagedObjectFactory.displayNameFor(owner, propertyName));
        }
        return instance;
    }

    public void applyRole(Object value, ModelObject owner) {
        this.roleHandler.applyRoleTo(owner, value);
    }

    public Object newInstance(ModelObject owner, String propertyName, Class<?> type) {
        Object providedType = this.getManagedObjectRegistry().newInstance(type);
        if (providedType != null) {
            return ManagedObjectFactory.attachOwner(providedType, owner, propertyName);
        }
        return ManagedObjectFactory.attachOwner(this.instantiator.newInstanceWithDisplayName(type, (Describable)ManagedObjectFactory.displayNameFor(owner, propertyName), new Object[0]), owner, propertyName);
    }

    public Object newInstance(ModelObject owner, String propertyName, Class<?> type, Class<?> paramType) {
        Object providedType = this.getManagedObjectRegistry().newInstance(type, paramType);
        if (providedType != null) {
            return ManagedObjectFactory.attachOwner(providedType, owner, propertyName);
        }
        throw new IllegalArgumentException("Unable to create an instance of type " + type.getName());
    }

    public Object newInstance(ModelObject owner, String propertyName, Class<?> type, Class<?> keyType, Class<?> valueType) {
        Object providedType = this.getManagedObjectRegistry().newInstance(type, keyType, valueType);
        if (providedType != null) {
            return ManagedObjectFactory.attachOwner(providedType, owner, propertyName);
        }
        throw new IllegalArgumentException("Unable to create an instance of type " + type.getName());
    }

    private static ManagedPropertyName displayNameFor(ModelObject owner, String propertyName) {
        if (owner.getModelIdentityDisplayName() instanceof ManagedPropertyName) {
            ManagedPropertyName root = (ManagedPropertyName)owner.getModelIdentityDisplayName();
            return new ManagedPropertyName((Cached<String>)root.ownerDisplayName, root.propertyName + "." + propertyName);
        }
        return new ManagedPropertyName(ManagedObjectFactory.cachedOwnerDisplayNameOf(owner), propertyName);
    }

    private static Cached<String> cachedOwnerDisplayNameOf(ModelObject owner) {
        return Cached.of(() -> {
            Describable ownerModelIdentityDisplayName = owner.getModelIdentityDisplayName();
            if (ownerModelIdentityDisplayName != null) {
                return ownerModelIdentityDisplayName.getDisplayName();
            }
            return null;
        });
    }

    private ManagedObjectRegistry getManagedObjectRegistry() {
        ManagedObjectRegistry managedObjectRegistry = (ManagedObjectRegistry)this.serviceLookup.find(ManagedObjectRegistry.class);
        if (managedObjectRegistry == null) {
            throw new IllegalStateException("No managed object registry found. ServiceLookup: " + this.serviceLookup);
        }
        return managedObjectRegistry;
    }

    private static class ManagedPropertyName
    implements DisplayName {
        private final Cached<String> ownerDisplayName;
        private final String propertyName;

        public ManagedPropertyName(Cached<String> ownerDisplayName, String propertyName) {
            this.ownerDisplayName = ownerDisplayName;
            this.propertyName = propertyName;
        }

        public String toString() {
            return this.getDisplayName();
        }

        public String getCapitalizedDisplayName() {
            return StringUtils.capitalize((String)this.getDisplayName());
        }

        public String getDisplayName() {
            if (this.ownerDisplayName.get() != null) {
                return (String)this.ownerDisplayName.get() + " property '" + this.propertyName + "'";
            }
            return "property '" + this.propertyName + "'";
        }
    }
}

