/*
 * Decompiled with CFR 0.152.
 */
package org.cts.op;

import org.cts.Identifier;
import org.cts.op.AbstractCoordinateOperation;
import org.cts.op.CoordinateOperation;

public class ChangeCoordinateDimension
extends AbstractCoordinateOperation {
    private static final Identifier G3DG2D = new Identifier("EPSG", "9659", "Geographic 3D to 2D conversion", "Geo3D->2D");
    private static final Identifier G2DG3D = new Identifier("EPSG", "9659i", "Geographic 2D to 3D conversion", "Geo2D->3D");
    public static final ChangeCoordinateDimension TO3D = new ChangeCoordinateDimension(G2DG3D, 2, 3){

        @Override
        public CoordinateOperation inverse() {
            return TO2D;
        }
    };
    public static final ChangeCoordinateDimension TO2D = new ChangeCoordinateDimension(G3DG2D, 3, 2){

        @Override
        public CoordinateOperation inverse() {
            return TO3D;
        }
    };
    private int inputDim;
    private int outputDim;

    private ChangeCoordinateDimension(Identifier identifier, int inputDim, int outputDim) {
        super(identifier);
        this.inputDim = inputDim;
        this.outputDim = outputDim;
    }

    @Override
    public double[] transform(double[] coord) {
        if (this.inputDim == this.outputDim) {
            return coord;
        }
        double[] cc = new double[this.outputDim];
        System.arraycopy(coord, 0, cc, 0, Math.min(this.inputDim, this.outputDim));
        return cc;
    }

    @Override
    public CoordinateOperation inverse() {
        return new ChangeCoordinateDimension(new Identifier(CoordinateOperation.class), this.outputDim, this.inputDim);
    }
}

