# --------------------------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
#
# Code generated by aaz-dev-tools
# --------------------------------------------------------------------------------------------

# pylint: skip-file
# flake8: noqa

from azure.cli.core.aaz import *


@register_command(
    "network traffic-manager endpoint show",
)
class Show(AAZCommand):
    """Get the details of a traffic manager endpoint.

    :example: Get the details of a traffic manager endpoint.
        az network traffic-manager endpoint show -g MyResourceGroup --profile-name MyTmProfile -n MyEndpoint --type azureEndpoints
    """

    _aaz_info = {
        "version": "2022-04-01",
        "resources": [
            ["mgmt-plane", "/subscriptions/{}/resourcegroups/{}/providers/microsoft.network/trafficmanagerprofiles/{}/{}/{}", "2022-04-01"],
        ]
    }

    def _handler(self, command_args):
        super()._handler(command_args)
        self._execute_operations()
        return self._output()

    _args_schema = None

    @classmethod
    def _build_arguments_schema(cls, *args, **kwargs):
        if cls._args_schema is not None:
            return cls._args_schema
        cls._args_schema = super()._build_arguments_schema(*args, **kwargs)

        # define Arg Group ""

        _args_schema = cls._args_schema
        _args_schema.name = AAZStrArg(
            options=["-n", "--name"],
            help="Endpoint name.",
            required=True,
            id_part="child_name_1",
        )
        _args_schema.type = AAZStrArg(
            options=["-t", "--type"],
            help="Endpoint type. Allowed values: azureEndpoints, externalEndpoints, nestedEndpoints.",
            required=True,
            id_part="child_type_1",
            enum={"AzureEndpoints": "AzureEndpoints", "ExternalEndpoints": "ExternalEndpoints", "NestedEndpoints": "NestedEndpoints"},
        )
        _args_schema.profile_name = AAZStrArg(
            options=["--profile-name"],
            help="Name of parent profile.",
            required=True,
            id_part="name",
        )
        _args_schema.resource_group = AAZResourceGroupNameArg(
            required=True,
        )
        return cls._args_schema

    def _execute_operations(self):
        self.pre_operations()
        self.EndpointsGet(ctx=self.ctx)()
        self.post_operations()

    @register_callback
    def pre_operations(self):
        pass

    @register_callback
    def post_operations(self):
        pass

    def _output(self, *args, **kwargs):
        result = self.deserialize_output(self.ctx.vars.instance, client_flatten=True)
        return result

    class EndpointsGet(AAZHttpOperation):
        CLIENT_TYPE = "MgmtClient"

        def __call__(self, *args, **kwargs):
            request = self.make_request()
            session = self.client.send_request(request=request, stream=False, **kwargs)
            if session.http_response.status_code in [200]:
                return self.on_200(session)

            return self.on_error(session.http_response)

        @property
        def url(self):
            return self.client.format_url(
                "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/trafficmanagerprofiles/{profileName}/{endpointType}/{endpointName}",
                **self.url_parameters
            )

        @property
        def method(self):
            return "GET"

        @property
        def error_format(self):
            return "ODataV4Format"

        @property
        def url_parameters(self):
            parameters = {
                **self.serialize_url_param(
                    "endpointName", self.ctx.args.name,
                    required=True,
                ),
                **self.serialize_url_param(
                    "endpointType", self.ctx.args.type,
                    required=True,
                ),
                **self.serialize_url_param(
                    "profileName", self.ctx.args.profile_name,
                    required=True,
                ),
                **self.serialize_url_param(
                    "resourceGroupName", self.ctx.args.resource_group,
                    required=True,
                ),
                **self.serialize_url_param(
                    "subscriptionId", self.ctx.subscription_id,
                    required=True,
                ),
            }
            return parameters

        @property
        def query_parameters(self):
            parameters = {
                **self.serialize_query_param(
                    "api-version", "2022-04-01",
                    required=True,
                ),
            }
            return parameters

        @property
        def header_parameters(self):
            parameters = {
                **self.serialize_header_param(
                    "Accept", "application/json",
                ),
            }
            return parameters

        def on_200(self, session):
            data = self.deserialize_http_content(session)
            self.ctx.set_var(
                "instance",
                data,
                schema_builder=self._build_schema_on_200
            )

        _schema_on_200 = None

        @classmethod
        def _build_schema_on_200(cls):
            if cls._schema_on_200 is not None:
                return cls._schema_on_200

            cls._schema_on_200 = AAZObjectType()

            _schema_on_200 = cls._schema_on_200
            _schema_on_200.id = AAZStrType()
            _schema_on_200.name = AAZStrType()
            _schema_on_200.properties = AAZObjectType(
                flags={"client_flatten": True},
            )
            _schema_on_200.type = AAZStrType()

            properties = cls._schema_on_200.properties
            properties.always_serve = AAZStrType(
                serialized_name="alwaysServe",
            )
            properties.custom_headers = AAZListType(
                serialized_name="customHeaders",
            )
            properties.endpoint_location = AAZStrType(
                serialized_name="endpointLocation",
            )
            properties.endpoint_monitor_status = AAZStrType(
                serialized_name="endpointMonitorStatus",
            )
            properties.endpoint_status = AAZStrType(
                serialized_name="endpointStatus",
            )
            properties.geo_mapping = AAZListType(
                serialized_name="geoMapping",
            )
            properties.min_child_endpoints = AAZIntType(
                serialized_name="minChildEndpoints",
            )
            properties.min_child_endpoints_i_pv4 = AAZIntType(
                serialized_name="minChildEndpointsIPv4",
            )
            properties.min_child_endpoints_i_pv6 = AAZIntType(
                serialized_name="minChildEndpointsIPv6",
            )
            properties.priority = AAZIntType()
            properties.subnets = AAZListType()
            properties.target = AAZStrType()
            properties.target_resource_id = AAZStrType(
                serialized_name="targetResourceId",
            )
            properties.weight = AAZIntType()

            custom_headers = cls._schema_on_200.properties.custom_headers
            custom_headers.Element = AAZObjectType()

            _element = cls._schema_on_200.properties.custom_headers.Element
            _element.name = AAZStrType()
            _element.value = AAZStrType()

            geo_mapping = cls._schema_on_200.properties.geo_mapping
            geo_mapping.Element = AAZStrType()

            subnets = cls._schema_on_200.properties.subnets
            subnets.Element = AAZObjectType()

            _element = cls._schema_on_200.properties.subnets.Element
            _element.first = AAZStrType()
            _element.last = AAZStrType()
            _element.scope = AAZIntType()

            return cls._schema_on_200


class _ShowHelper:
    """Helper class for Show"""


__all__ = ["Show"]
