\name{ShiftScaleImageFilter}
\alias{ShiftScaleImageFilter}
\title{ShiftScaleImageFilter}
\Rdversion{1.1}
\docType{class}
\description{
Shift and scale the pixels in an image.
ShiftScaleImageFilter}
\details{
ShiftScaleImageFilter shifts the input pixel by Shift (default 0.0) and then scales the
pixel by Scale (default 1.0). All computations are performed in the
precision of the input pixel's RealType. Before assigning the computed
value to the output pixel, the value is clamped at the NonpositiveMin
and max of the pixel type.
See:
ShiftScale for the procedural interface
itk::ShiftScaleImageFilter for the Doxygen on the original ITK class.
ShiftScaleImageFilter}
%C++ includes: sitkShiftScaleImageFilter.h
\section{Methods}{
\describe{
\item{Image Execute(const Image &image1):}{
Execute the filter on the input image
}
\item{std::string GetName() const:}{
Name of this class
}
\item{PixelIDValueEnum GetOutputPixelType() const:}{
Get the output pixel type.
}
\item{int64_t GetOverflowCount() const:}{
Get the number of pixels that underflowed and overflowed.
This is a measurement. Its value is updated in the Execute methods, so
the value will only be valid after an execution.
}
\item{double GetScale() const:}{
Set/Get the amount to Scale each Pixel. The Scale is applied after the
Shift.
}
\item{double GetShift() const:}{
Set/Get the amount to Shift each Pixel. The shift is followed by a
Scale.
}
\item{int64_t GetUnderflowCount() const:}{
Get the number of pixels that underflowed and overflowed.
This is a measurement. Its value is updated in the Execute methods, so
the value will only be valid after an execution.
}
\item{Self SetOutputPixelType(PixelIDValueEnum OutputPixelType):}{
Set the output pixel type, if sitkUnknown then the input type is used.
}
\item{Self SetScale(double Scale):}{
Set/Get the amount to Scale each Pixel. The Scale is applied after the
Shift.
}
\item{Self SetShift(double Shift):}{
Set/Get the amount to Shift each Pixel. The shift is followed by a
Scale.
}
\item{ ShiftScaleImageFilter():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{std::string ToString() const:}{
Print ourselves out
}
\item{ ~ShiftScaleImageFilter():}{
Destructor
}
}
}
