/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fonts.autodetect;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.io.DirectoryWalker;
import org.apache.commons.io.IOCase;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.fonts.FontEventListener;
import org.apache.fop.fonts.autodetect.FontDirFinder;
import org.apache.fop.fonts.autodetect.FontFinder;
import org.apache.fop.fonts.autodetect.MacFontDirFinder;
import org.apache.fop.fonts.autodetect.UnixFontDirFinder;
import org.apache.fop.fonts.autodetect.WindowsFontDirFinder;

public class FontFileFinder
extends DirectoryWalker
implements FontFinder {
    private final Log log = LogFactory.getLog(FontFileFinder.class);
    public static final int DEFAULT_DEPTH_LIMIT = -1;
    private final FontEventListener eventListener;

    public FontFileFinder(FontEventListener listener) {
        this(-1, listener);
    }

    public FontFileFinder(int depthLimit, FontEventListener listener) {
        super(FontFileFinder.getDirectoryFilter(), FontFileFinder.getFileFilter(), depthLimit);
        this.eventListener = listener;
    }

    protected static IOFileFilter getDirectoryFilter() {
        return FileFilterUtils.and(FileFilterUtils.directoryFileFilter(), FileFilterUtils.notFileFilter(FileFilterUtils.prefixFileFilter(".")));
    }

    protected static IOFileFilter getFileFilter() {
        return FileFilterUtils.and(FileFilterUtils.fileFileFilter(), WildcardFileFilter.builder().setIoCase(IOCase.INSENSITIVE).setWildcards("*.ttf", "*.otf", "*.pfb", "*.ttc").get());
    }

    protected boolean handleDirectory(File directory, int depth, Collection results) {
        return true;
    }

    protected void handleFile(File file, int depth, Collection results) {
        try {
            results.add(file.toURI().toURL());
        }
        catch (MalformedURLException e) {
            this.log.debug("MalformedURLException" + e.getMessage());
        }
    }

    protected void handleDirectoryEnd(File directory, int depth, Collection results) {
        if (this.log.isDebugEnabled()) {
            this.log.debug(directory + ": found " + results.size() + " font" + (results.size() == 1 ? "" : "s"));
        }
    }

    @Override
    public List<URL> find() throws IOException {
        String osName = System.getProperty("os.name");
        FontDirFinder fontDirFinder = osName.startsWith("Windows") ? new WindowsFontDirFinder() : (osName.startsWith("Mac") ? new MacFontDirFinder() : new UnixFontDirFinder());
        List<File> fontDirs = fontDirFinder.find();
        ArrayList<URL> results = new ArrayList<URL>();
        for (File dir : fontDirs) {
            this.walkDirectory(dir, results);
        }
        return results;
    }

    public List<URL> find(File directory) throws IOException {
        ArrayList<URL> results = new ArrayList<URL>();
        if (!directory.isDirectory()) {
            this.eventListener.fontDirectoryNotFound(this, directory.getAbsolutePath());
        } else {
            this.walkDirectory(directory, results);
        }
        return results;
    }

    private void walkDirectory(File startDirectory, Collection<URL> results) throws IOException {
        Objects.requireNonNull(startDirectory, "startDirectory");
        try {
            this.walk(startDirectory, 0, results, new HashMap<String, String>());
        }
        catch (DirectoryWalker.CancelException cancel) {
            this.handleCancelled(startDirectory, results, cancel);
        }
    }

    private void walk(File directory, int depth, Collection<URL> results, Map<String, String> visitedSymlinks) throws IOException {
        IOFileFilter fileFilter = FileFilterUtils.makeFileOnly(FontFileFinder.getFileFilter());
        IOFileFilter directoryFilter = FileFilterUtils.makeDirectoryOnly(FontFileFinder.getDirectoryFilter());
        IOFileFilter filter = directoryFilter.or(fileFilter);
        this.checkIfCancelled(directory, depth, results);
        int childDepth = depth + 1;
        File[] childFiles = directory.listFiles(filter);
        if (childFiles != null) {
            for (File childFile : childFiles) {
                if (childFile.isDirectory()) {
                    if (Files.isSymbolicLink(childFile.toPath()) && this.hasSymlinkBeenWalked(childFile, visitedSymlinks)) continue;
                    this.walk(childFile, childDepth, results, visitedSymlinks);
                    continue;
                }
                this.checkIfCancelled(childFile, childDepth, results);
                this.handleFile(childFile, childDepth, results);
                this.checkIfCancelled(childFile, childDepth, results);
            }
        }
        this.handleDirectoryEnd(directory, depth, results);
        this.checkIfCancelled(directory, depth, results);
    }

    private boolean hasSymlinkBeenWalked(File symlink, Map<String, String> visitedSymlinks) {
        String symlinkPath;
        try {
            symlinkPath = symlink.toPath().toRealPath(new LinkOption[0]).toString();
        }
        catch (IOException e) {
            this.log.warn("Failed to get symlink path: " + e.getMessage());
            symlinkPath = symlink.getAbsolutePath();
        }
        for (Map.Entry<String, String> entry : visitedSymlinks.entrySet()) {
            if (!symlinkPath.startsWith(entry.getKey()) || !entry.getValue().equals(symlink.getName())) continue;
            return true;
        }
        visitedSymlinks.put(symlinkPath, symlink.getName());
        return false;
    }
}

