/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.criterion;

import javax.annotation.Nonnull;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.StringSupport;
import net.shibboleth.shared.resolver.Criterion;

public final class ProtocolCriterion
implements Criterion {
    @Nonnull
    @NotEmpty
    private final String protocol;

    public ProtocolCriterion(@Nonnull @NotEmpty String protocolUri) {
        this.protocol = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)protocolUri), (String)"SAML protocol URI cannot be null or empty");
    }

    @Nonnull
    @NotEmpty
    public String getProtocol() {
        return this.protocol;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ProtocolCriterion [protocol=");
        builder.append(this.protocol);
        builder.append("]");
        return builder.toString();
    }

    public int hashCode() {
        return this.protocol.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof ProtocolCriterion) {
            ProtocolCriterion other = (ProtocolCriterion)obj;
            return this.protocol.equals(other.protocol);
        }
        return false;
    }
}

