/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.component;

import jakarta.inject.Provider;
import java.io.ObjectStreamException;
import java.io.Serializable;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.exception.WebBeansException;
import org.apache.webbeans.spi.ResourceInjectionService;
import org.apache.webbeans.spi.api.ResourceReference;

public class ResourceProvider<T>
implements Provider<T>,
Serializable {
    private ResourceReference<T, ?> resourceReference;
    private transient WebBeansContext webBeansContext;

    public ResourceProvider(ResourceReference<T, ?> resourceReference, WebBeansContext webBeansContext) {
        this.resourceReference = resourceReference;
        this.webBeansContext = webBeansContext;
    }

    public T get() {
        if (this.webBeansContext == null) {
            this.webBeansContext = WebBeansContext.currentInstance();
        }
        try {
            ResourceInjectionService resourceService = this.webBeansContext.getService(ResourceInjectionService.class);
            return (T)resourceService.getResourceReference(this.resourceReference);
        }
        catch (Exception e) {
            throw new WebBeansException(e);
        }
    }

    Object readResolve() throws ObjectStreamException {
        return this.get();
    }
}

