/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.kernel.exps;

import org.apache.openjpa.kernel.Filters;
import org.apache.openjpa.kernel.StoreContext;
import org.apache.openjpa.kernel.exps.Exp;
import org.apache.openjpa.kernel.exps.ExpressionVisitor;
import org.apache.openjpa.kernel.exps.Val;
import org.apache.openjpa.kernel.exps.WhenCondition;
import org.apache.openjpa.lib.util.Localizer;

class GeneralCase
extends Val {
    private static final long serialVersionUID = 1L;
    private static final Localizer _loc = Localizer.forPackage(GeneralCase.class);
    private final Exp[] _exp;
    private final Val _val;

    public GeneralCase(Exp[] exp, Val val) {
        this._exp = exp;
        this._val = val;
    }

    @Override
    protected Object eval(Object candidate, Object orig, StoreContext ctx, Object[] params) {
        for (Exp exp : this._exp) {
            boolean compare = ((WhenCondition)exp).getExp().eval(candidate, orig, ctx, params);
            if (!compare) continue;
            return ((WhenCondition)exp).getVal().eval(candidate, orig, ctx, params);
        }
        return this._val.eval(candidate, orig, ctx, params);
    }

    protected Object eval(Object candidate, StoreContext ctx, Object[] params) {
        for (Exp exp : this._exp) {
            boolean compare = ((WhenCondition)exp).getExp().eval(candidate, null, ctx, params);
            if (!compare) continue;
            return ((WhenCondition)exp).getVal().eval(candidate, null, ctx, params);
        }
        return this._val.eval(candidate, null, ctx, params);
    }

    @Override
    public Class getType() {
        Class<?> c1 = this._val.getType();
        for (Exp exp : this._exp) {
            Class c2 = ((WhenCondition)exp).getVal().getType();
            c1 = Filters.promote(c1, c2);
        }
        return c1;
    }

    @Override
    public void setImplicitType(Class type) {
    }

    @Override
    public void acceptVisit(ExpressionVisitor visitor) {
        visitor.enter(this);
        for (Exp exp : this._exp) {
            exp.acceptVisit(visitor);
        }
        this._val.acceptVisit(visitor);
        visitor.exit(this);
    }
}

