/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.fsprovider.internal.mapper.jcr;

import javax.jcr.AccessDeniedException;
import javax.jcr.InvalidItemStateException;
import javax.jcr.Item;
import javax.jcr.ItemExistsException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.ItemVisitor;
import javax.jcr.Node;
import javax.jcr.ReferentialIntegrityException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.version.VersionException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.fsprovider.internal.mapper.ContentFile;

abstract class FsItem
implements Item {
    protected final ContentFile contentFile;
    protected final ResourceResolver resolver;
    protected final ValueMap props;

    public FsItem(ContentFile contentFile, ResourceResolver resolver) {
        this.contentFile = contentFile;
        this.resolver = resolver;
        this.props = contentFile.getValueMap();
    }

    public String getPath() throws RepositoryException {
        if (this.contentFile.getSubPath() == null) {
            return this.contentFile.getPath();
        }
        return this.contentFile.getPath() + "/" + this.contentFile.getSubPath();
    }

    public Item getAncestor(int depth) throws ItemNotFoundException, AccessDeniedException, RepositoryException {
        Node refNode;
        String path;
        if (depth == 0) {
            path = "/";
        } else {
            Object[] pathParts = StringUtils.splitPreserveAllTokens((String)this.getPath(), (String)"/");
            path = StringUtils.join((Object[])pathParts, (String)"/", (int)0, (int)(depth + 1));
        }
        Resource resource = this.resolver.getResource(path);
        if (resource != null && (refNode = (Node)resource.adaptTo(Node.class)) != null) {
            return refNode;
        }
        throw new ItemNotFoundException();
    }

    public int getDepth() throws RepositoryException {
        if (StringUtils.equals((CharSequence)"/", (CharSequence)this.getPath())) {
            return 0;
        }
        return StringUtils.countMatches((CharSequence)this.getPath(), (CharSequence)"/");
    }

    public Session getSession() throws RepositoryException {
        return (Session)this.resolver.adaptTo(Session.class);
    }

    public boolean isNode() {
        return this instanceof Node;
    }

    public boolean isNew() {
        return false;
    }

    public boolean isModified() {
        return false;
    }

    public boolean isSame(Item otherItem) throws RepositoryException {
        return StringUtils.equals((CharSequence)this.getPath(), (CharSequence)otherItem.getPath());
    }

    public void accept(ItemVisitor visitor) throws RepositoryException {
    }

    public String toString() {
        try {
            return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("path", (Object)this.getPath()).build();
        }
        catch (RepositoryException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void save() throws AccessDeniedException, ItemExistsException, ConstraintViolationException, InvalidItemStateException, ReferentialIntegrityException, VersionException, LockException, NoSuchNodeTypeException, RepositoryException {
        throw new UnsupportedOperationException();
    }

    public void refresh(boolean keepChanges) throws InvalidItemStateException, RepositoryException {
        throw new UnsupportedOperationException();
    }

    public void remove() throws VersionException, LockException, ConstraintViolationException, AccessDeniedException, RepositoryException {
        throw new UnsupportedOperationException();
    }
}

