/*
 * Decompiled with CFR 0.152.
 */
package relocated_for_contentpackage.org.apache.jackrabbit.vault.fs.impl.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import relocated_for_contentpackage.javax.jcr.Node;
import relocated_for_contentpackage.javax.jcr.RepositoryException;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.fs.api.Artifact;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.fs.api.ImportMode;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.fs.api.SerializationType;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.fs.api.WorkspaceFilter;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.fs.impl.ArtifactSetImpl;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.fs.impl.io.AbstractArtifactHandler;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.fs.impl.io.CNDImporter;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.fs.impl.io.ImportInfoImpl;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.util.PathUtil;

public class NodeTypeArtifactHandler
extends AbstractArtifactHandler {
    @Override
    protected ImportInfoImpl accept(WorkspaceFilter wspFilter, Node parent, String name, ArtifactSetImpl artifacts) throws RepositoryException, IOException {
        Artifact primary = artifacts.getPrimaryData();
        if (primary == null) {
            return null;
        }
        if (artifacts.size() != 1) {
            return null;
        }
        if (primary.getSerializationType() != SerializationType.CND) {
            return null;
        }
        String path = PathUtil.getPath(parent, primary.getRelativePath());
        if (wspFilter.getImportMode(path) == ImportMode.MERGE) {
            ImportInfoImpl info = new ImportInfoImpl();
            info.onNop(path);
            return info;
        }
        CNDImporter importer = new CNDImporter();
        try (InputStream in = primary.getInputStream();){
            InputStreamReader r = new InputStreamReader(in, "utf-8");
            ImportInfoImpl importInfoImpl = importer.doImport(parent, primary.getRelativePath(), r, primary.getRelativePath());
            return importInfoImpl;
        }
    }
}

