/*
 * Decompiled with CFR 0.152.
 */
package relocated_for_contentpackage.org.apache.jackrabbit.spi2dav;

import org.w3c.dom.Element;
import org.w3c.dom.Node;
import relocated_for_contentpackage.javax.jcr.NamespaceException;
import relocated_for_contentpackage.javax.jcr.PropertyType;
import relocated_for_contentpackage.javax.jcr.RepositoryException;
import relocated_for_contentpackage.org.apache.jackrabbit.spi.Name;
import relocated_for_contentpackage.org.apache.jackrabbit.spi.QValue;
import relocated_for_contentpackage.org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;
import relocated_for_contentpackage.org.apache.jackrabbit.spi.commons.name.NameConstants;
import relocated_for_contentpackage.org.apache.jackrabbit.webdav.xml.DomUtil;
import relocated_for_contentpackage.org.apache.jackrabbit.webdav.xml.Namespace;

final class BatchUtils {
    private static final Namespace SV_NAMESPACE = Namespace.getNamespace("sv", "http://www.jcp.org/jcr/sv/1.0");
    private static final String NODE_ELEMENT = "node";
    private static final String PROPERTY_ELEMENT = "property";
    private static final String VALUE_ELEMENT = "value";
    private static final String NAME_ATTRIBUTE = "name";
    private static final String TYPE_ATTRIBUTE = "type";

    private BatchUtils() {
    }

    static Element createNodeElement(Node parent, Name nodeName, Name primaryTypeName, String uniqueId, NamePathResolver resolver) throws NamespaceException {
        Element nodeElement = DomUtil.addChildElement(parent, NODE_ELEMENT, SV_NAMESPACE);
        String nameAttr = resolver.getJCRName(nodeName);
        DomUtil.setAttribute(nodeElement, NAME_ATTRIBUTE, SV_NAMESPACE, nameAttr);
        Element propElement = DomUtil.addChildElement(nodeElement, PROPERTY_ELEMENT, SV_NAMESPACE);
        String name = resolver.getJCRName(NameConstants.JCR_PRIMARYTYPE);
        DomUtil.setAttribute(propElement, NAME_ATTRIBUTE, SV_NAMESPACE, name);
        DomUtil.setAttribute(propElement, TYPE_ATTRIBUTE, SV_NAMESPACE, PropertyType.nameFromValue(7));
        name = resolver.getJCRName(primaryTypeName);
        DomUtil.addChildElement(propElement, VALUE_ELEMENT, SV_NAMESPACE, name);
        if (uniqueId != null) {
            propElement = DomUtil.addChildElement(nodeElement, PROPERTY_ELEMENT, SV_NAMESPACE);
            name = resolver.getJCRName(NameConstants.JCR_UUID);
            DomUtil.setAttribute(propElement, NAME_ATTRIBUTE, SV_NAMESPACE, name);
            DomUtil.setAttribute(propElement, TYPE_ATTRIBUTE, SV_NAMESPACE, PropertyType.nameFromValue(1));
            DomUtil.addChildElement(propElement, VALUE_ELEMENT, SV_NAMESPACE, uniqueId);
        }
        return nodeElement;
    }

    static void importProperty(Element nodeElement, Name propertyName, int type, QValue[] values, NamePathResolver resolver) throws RepositoryException {
        Element propElement = DomUtil.addChildElement(nodeElement, PROPERTY_ELEMENT, SV_NAMESPACE);
        DomUtil.setAttribute(propElement, NAME_ATTRIBUTE, SV_NAMESPACE, resolver.getJCRName(propertyName));
        DomUtil.setAttribute(propElement, TYPE_ATTRIBUTE, SV_NAMESPACE, PropertyType.nameFromValue(type));
        for (QValue value : values) {
            DomUtil.addChildElement(propElement, VALUE_ELEMENT, SV_NAMESPACE, value.getString());
        }
    }
}

