/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.queue.impl.jobhandling;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.sling.distribution.queue.DistributionQueueEntry;
import org.apache.sling.distribution.queue.DistributionQueueItem;
import org.apache.sling.distribution.queue.DistributionQueueItemState;
import org.apache.sling.distribution.queue.DistributionQueueItemStatus;
import org.apache.sling.event.jobs.Job;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class JobHandlingUtils {
    private static final Logger log = LoggerFactory.getLogger(JobHandlingUtils.class);
    private static final String ID_START = "dstrpck-";
    private static final String DISTRIBUTION_PACKAGE_PREFIX = "distribution.";
    private static final String DISTRIBUTION_PACKAGE_ID = "distribution.item.id";
    private static final String DISTRIBUTION_PACKAGE_SIZE = "distribution.package.size";

    JobHandlingUtils() {
    }

    public static DistributionQueueItem getItem(Job job) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        String packageId = (String)job.getProperty(DISTRIBUTION_PACKAGE_ID);
        Object sizeProperty = job.getProperty(DISTRIBUTION_PACKAGE_SIZE);
        long size = sizeProperty != null ? Long.valueOf(sizeProperty.toString()) : -1L;
        try {
            Set propertyNames = job.getPropertyNames();
            for (String key : propertyNames) {
                if (!key.startsWith(DISTRIBUTION_PACKAGE_PREFIX)) continue;
                String infoKey = key.substring(DISTRIBUTION_PACKAGE_PREFIX.length());
                properties.put(infoKey, job.getProperty(key));
            }
        }
        catch (Throwable t) {
            log.error("Cannot read job {} properties", (Object)job.getId(), (Object)t);
        }
        return new DistributionQueueItem(packageId, size, properties);
    }

    public static Map<String, Object> createFullProperties(DistributionQueueItem queueItem) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        for (String key : queueItem.keySet()) {
            Object value = queueItem.get(key);
            if (value == null) continue;
            properties.put(DISTRIBUTION_PACKAGE_PREFIX + key, queueItem.get(key));
        }
        properties.put(DISTRIBUTION_PACKAGE_ID, queueItem.getPackageId());
        properties.put(DISTRIBUTION_PACKAGE_SIZE, queueItem.getSize());
        return properties;
    }

    @Nullable
    private static String getQueueName(Job job) {
        String topic = job.getTopic();
        if (topic == null || !topic.startsWith("org/apache/sling/distribution/queue")) {
            return null;
        }
        String queue = topic.substring("org/apache/sling/distribution/queue".length() + 1);
        int idx = queue.lastIndexOf("/");
        if (idx < 0) {
            return "";
        }
        return queue.substring(idx + 1);
    }

    public static DistributionQueueItemStatus getStatus(Job job) {
        String queueName = JobHandlingUtils.getQueueName(job);
        int attempts = job.getRetryCount();
        return new DistributionQueueItemStatus(job.getCreated(), attempts > 0 ? DistributionQueueItemState.ERROR : DistributionQueueItemState.QUEUED, attempts, queueName);
    }

    @Nullable
    public static DistributionQueueEntry getEntry(Job job) {
        DistributionQueueItem item = JobHandlingUtils.getItem(job);
        DistributionQueueItemStatus itemStatus = JobHandlingUtils.getStatus(job);
        if (item != null && itemStatus != null) {
            return new DistributionQueueEntry(JobHandlingUtils.escapeId(job.getId()), item, itemStatus);
        }
        return null;
    }

    private static String escapeId(String jobId) {
        if (jobId == null) {
            return null;
        }
        return ID_START + jobId.replace("/", "--");
    }

    public static String unescapeId(String itemId) {
        if (itemId == null) {
            return null;
        }
        if (!itemId.startsWith(ID_START)) {
            return null;
        }
        return itemId.replace(ID_START, "").replace("--", "/");
    }
}

