/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.ide.eclipse.core.internal;

import java.util.Optional;
import org.apache.sling.ide.artifacts.EmbeddedBundleLocator;
import org.apache.sling.ide.eclipse.core.ExtendedServiceTracker;
import org.apache.sling.ide.eclipse.core.Preferences;
import org.apache.sling.ide.eclipse.core.launch.SourceReferenceResolver;
import org.apache.sling.ide.filter.FilterLocator;
import org.apache.sling.ide.log.Logger;
import org.apache.sling.ide.osgi.OsgiClientFactory;
import org.apache.sling.ide.serialization.SerializationManager;
import org.apache.sling.ide.sync.content.SyncCommandFactory;
import org.apache.sling.ide.transport.BatcherFactory;
import org.apache.sling.ide.transport.RepositoryFactory;
import org.eclipse.core.runtime.Plugin;
import org.osgi.framework.BundleContext;

public class Activator
extends Plugin {
    public static final String PLUGIN_ID = "org.apache.sling.ide.eclipse-core";
    private static Activator plugin;
    private ExtendedServiceTracker<RepositoryFactory> repositoryFactory;
    private ExtendedServiceTracker<SerializationManager> serializationManager;
    private ExtendedServiceTracker<FilterLocator> filterLocator;
    private ExtendedServiceTracker<OsgiClientFactory> osgiClientFactory;
    private ExtendedServiceTracker<EmbeddedBundleLocator> bundleLocator;
    private ExtendedServiceTracker<Logger> tracer;
    private ExtendedServiceTracker<BatcherFactory> batcherFactoryLocator;
    private ExtendedServiceTracker<SourceReferenceResolver> sourceReferenceLocator;
    private ExtendedServiceTracker<SyncCommandFactory> commandFactory;
    private Preferences preferences;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        this.repositoryFactory = new ExtendedServiceTracker<RepositoryFactory>(context, RepositoryFactory.class);
        this.serializationManager = new ExtendedServiceTracker<SerializationManager>(context, SerializationManager.class);
        this.filterLocator = new ExtendedServiceTracker<FilterLocator>(context, FilterLocator.class);
        this.osgiClientFactory = new ExtendedServiceTracker<OsgiClientFactory>(context, OsgiClientFactory.class);
        this.bundleLocator = new ExtendedServiceTracker<EmbeddedBundleLocator>(context, EmbeddedBundleLocator.class);
        this.tracer = new ExtendedServiceTracker<Logger>(context, Logger.class);
        this.batcherFactoryLocator = new ExtendedServiceTracker<BatcherFactory>(context, BatcherFactory.class);
        this.sourceReferenceLocator = new ExtendedServiceTracker<SourceReferenceResolver>(context, SourceReferenceResolver.class);
        this.commandFactory = new ExtendedServiceTracker<SyncCommandFactory>(context, SyncCommandFactory.class);
    }

    public void stop(BundleContext context) throws Exception {
        this.repositoryFactory.close();
        this.serializationManager.close();
        this.filterLocator.close();
        this.osgiClientFactory.close();
        this.bundleLocator.close();
        this.tracer.close();
        this.batcherFactoryLocator.close();
        this.sourceReferenceLocator.close();
        this.commandFactory.close();
        plugin = null;
        super.stop(context);
    }

    public static Activator getDefault() {
        return plugin;
    }

    public RepositoryFactory getRepositoryFactory() {
        return this.repositoryFactory.getNotNull();
    }

    public SerializationManager getSerializationManager() {
        return this.serializationManager.getNotNull();
    }

    public FilterLocator getFilterLocator() {
        return this.filterLocator.getNotNull();
    }

    public OsgiClientFactory getOsgiClientFactory() {
        return this.osgiClientFactory.getNotNull();
    }

    public EmbeddedBundleLocator getEmbeddedBundleLocator() {
        return this.bundleLocator.getNotNull();
    }

    public Logger getPluginLogger() {
        return this.tracer.getNotNull();
    }

    public BatcherFactory getBatcherFactory() {
        return this.batcherFactoryLocator.getNotNull();
    }

    public SyncCommandFactory getCommandFactory() {
        return this.commandFactory.getNotNull();
    }

    public Optional<SourceReferenceResolver> getSourceReferenceResolver() {
        return this.sourceReferenceLocator.getOptional();
    }

    public Preferences getPreferences() {
        if (this.preferences == null) {
            this.preferences = new Preferences();
        }
        return this.preferences;
    }
}

