/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.base;

import jakarta.xml.bind.JAXBException;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Optional;
import java.util.logging.Filter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.xml.transform.Source;
import org.apache.sis.io.stream.IOUtilities;
import org.apache.sis.setup.OptionKey;
import org.apache.sis.storage.DataOptionKey;
import org.apache.sis.storage.DataStore;
import org.apache.sis.storage.DataStoreContentException;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.DataStoreProvider;
import org.apache.sis.storage.ReadOnlyStorageException;
import org.apache.sis.storage.Resource;
import org.apache.sis.storage.StorageConnector;
import org.apache.sis.storage.base.AuxiliaryContent;
import org.apache.sis.storage.base.MetadataBuilder;
import org.apache.sis.storage.base.StoreResource;
import org.apache.sis.storage.internal.Resources;
import org.apache.sis.storage.xml.AbstractProvider;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.iso.Names;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.xml.XML;
import org.apache.sis.xml.internal.shared.ExceptionSimplifier;
import org.apache.sis.xml.internal.shared.URISource;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.util.GenericName;

public abstract class URIDataStore
extends DataStore
implements StoreResource {
    protected final URI location;
    protected final Path locationAsPath;
    private final Path metadataPath;
    protected Charset encoding;
    protected Locale dataLocale;
    protected ZoneId timezone;

    protected URIDataStore(DataStoreProvider provider, StorageConnector connector) throws DataStoreException {
        super(provider, connector);
        this.location = connector.getStorageAs(URI.class);
        this.locationAsPath = connector.getStorageAs(Path.class);
        this.metadataPath = this.locationAsPath != null || this.location != null ? connector.getOption(DataOptionKey.METADATA_PATH) : null;
        this.encoding = (Charset)connector.getOption(OptionKey.ENCODING);
        this.dataLocale = (Locale)connector.getOption(OptionKey.LOCALE);
        this.timezone = (ZoneId)connector.getOption(OptionKey.TIMEZONE);
    }

    @Override
    public final DataStore getOriginator() {
        return this;
    }

    @Override
    public Optional<GenericName> getIdentifier() throws DataStoreException {
        String filename = this.getFilename();
        return filename != null ? Optional.of(Names.createLocalName(null, null, (CharSequence)filename)) : super.getIdentifier();
    }

    public final String getFilename() {
        if (this.location == null) {
            return null;
        }
        return IOUtilities.filenameWithoutExtension(this.location.isOpaque() ? this.location.getSchemeSpecificPart() : this.location.getPath());
    }

    @Override
    public Optional<Resource.FileSet> getFileSet() throws DataStoreException {
        Object[] paths;
        try {
            paths = new Path[]{this.locationAsPath, this.getMetadataPath()};
        }
        catch (IOException e) {
            throw new DataStoreException(e);
        }
        int count = ArraysExt.removeDuplicated((Object[])paths, (int)ArraysExt.removeNulls((Object[])paths));
        if (count != 0) {
            return Optional.of(new Resource.FileSet((Path[])ArraysExt.resize((Object[])paths, (int)count)));
        }
        return Optional.empty();
    }

    @Override
    public Optional<ParameterValueGroup> getOpenParameters() {
        return Optional.ofNullable(URIDataStore.parameters(this.provider, this.location));
    }

    public static ParameterValueGroup parameters(DataStoreProvider provider, URI location) {
        if (location == null || provider == null) {
            return null;
        }
        ParameterValueGroup pg = provider.getOpenParameters().createValue();
        pg.parameter("location").setValue((Object)location);
        return pg;
    }

    private Path replaceWildcard(Path path) {
        if (path != null) {
            boolean changed = false;
            String filename = null;
            String[] names = new String[path.getNameCount()];
            int count = 0;
            for (Path p : path) {
                String name = p.toString();
                if (name.indexOf(42) >= 0) {
                    if (filename == null) {
                        filename = IOUtilities.filename(this.locationAsPath != null ? this.locationAsPath : this.location);
                        if (filename == null) {
                            return null;
                        }
                        int s = filename.lastIndexOf(46);
                        if (s >= 0) {
                            filename = filename.substring(0, s);
                        }
                    }
                    name = name.replace("*", filename);
                    changed = true;
                }
                names[count++] = name;
            }
            if (changed) {
                path = path.getFileSystem().getPath(names[0], Arrays.copyOfRange(names, 1, count));
            }
        }
        return path;
    }

    private Path getMetadataPath() throws IOException {
        Path path = this.replaceWildcard(this.metadataPath);
        if (path != null) {
            Path parent = this.locationAsPath;
            if (parent != null && (parent = parent.getParent()) != null) {
                path = parent.resolve(path);
            }
            if (Files.isSameFile(path, this.locationAsPath)) {
                return null;
            }
        }
        return path;
    }

    private URI getMetadataURI() throws URISyntaxException {
        Path path;
        URI uri = this.location;
        if (uri != null && (path = this.replaceWildcard(this.metadataPath)) != null && !(uri = IOUtilities.toAuxiliaryURI(uri, path.toString(), false)).equals(this.location)) {
            return uri;
        }
        return null;
    }

    private static InputStream open(Path path) throws IOException {
        return new BufferedInputStream(Files.newInputStream(path, StandardOpenOption.READ), 1024);
    }

    protected final void mergeAuxiliaryMetadata(Class<? extends DataStore> caller, MetadataBuilder builder) {
        Comparable<Path> spec = null;
        Object metadata = null;
        try {
            InputStream input;
            URI source;
            Path path = this.getMetadataPath();
            if (path != null) {
                spec = path;
                source = path.toUri();
                input = URIDataStore.open(path);
            } else {
                source = this.getMetadataURI();
                if (source == null) {
                    return;
                }
                spec = source;
                input = source.toURL().openStream();
            }
            metadata = this.readXML(input, source);
        }
        catch (IOException | URISyntaxException e) {
            this.cannotReadAuxiliaryFile(caller, "getMetadata", "xml", e, true);
        }
        catch (JAXBException e) {
            Throwable cause = e.getCause();
            if (cause instanceof IOException) {
                this.cannotReadAuxiliaryFile(caller, "getMetadata", "xml", (Exception)cause, true);
            }
            this.listeners.warning(new ExceptionSimplifier((Object)spec, (Exception)((Object)e)).record(URIDataStore.class, "mergeAuxiliaryMetadata"));
        }
        if (metadata != null) {
            builder.mergeMetadata(metadata, this.getLocale());
        }
    }

    protected final Object readXML(InputStream input, URI source) throws URISyntaxException, IOException, JAXBException {
        try (InputStream inputStream = input;){
            Object object = this.readXML(URISource.create((InputStream)input, (URI)source));
            return object;
        }
    }

    protected final Object readXML(Source source) throws JAXBException {
        Filter handler = record -> {
            record.setLoggerName(null);
            this.listeners.warning(record);
            return false;
        };
        HashMap<String, Object> properties = new HashMap<String, Object>(8);
        properties.put("org.apache.sis.xml.locale", this.dataLocale);
        properties.put("org.apache.sis.xml.timezone", this.timezone);
        properties.put("org.apache.sis.xml.warningFilter", handler);
        return XML.unmarshal((Source)source, properties);
    }

    protected final AuxiliaryContent readAuxiliaryFile(String extension, boolean acceptXML) throws URISyntaxException, IOException, DataStoreException {
        URI sourceURI;
        Object source;
        InputStream stream;
        Path path = this.locationAsPath;
        if (path != null) {
            if (extension != null) {
                path = path.resolveSibling(URIDataStore.getBaseFilename(path).concat(extension));
            }
            stream = URIDataStore.open(path);
            source = path;
            sourceURI = null;
        } else {
            try {
                URI uRI = sourceURI = extension != null ? IOUtilities.toAuxiliaryURI(this.location, extension, true) : this.location;
                if (sourceURI == null) {
                    return null;
                }
                URL url = sourceURI.toURL();
                stream = url.openStream();
                source = url;
            }
            catch (URISyntaxException e) {
                throw new DataStoreException(this.cannotReadAuxiliaryFile(extension), e);
            }
        }
        if (acceptXML && stream.markSupported() && AbstractProvider.isXML(stream)) {
            return new AuxiliaryContent(source, URISource.create((InputStream)stream, (URI)(path != null ? path.toUri() : sourceURI)));
        }
        AuxiliaryContent content = AuxiliaryContent.read(source, stream, this.encoding);
        if (content != null) {
            return content;
        }
        throw new DataStoreContentException(Resources.forLocale(this.getLocale()).getString((short)71, IOUtilities.filename(source)));
    }

    protected final BufferedWriter writeAuxiliaryFile(String extension) throws IOException, DataStoreException {
        Path path = this.locationAsPath;
        if (path == null) {
            throw new ReadOnlyStorageException(Resources.forLocale(this.getLocale()).getString((short)69, this.getDisplayName()));
        }
        path = path.resolveSibling(URIDataStore.getBaseFilename(path).concat(extension));
        return this.encoding != null ? Files.newBufferedWriter(path, this.encoding, new OpenOption[0]) : Files.newBufferedWriter(path, new OpenOption[0]);
    }

    protected final void deleteAuxiliaryFile(String extension) throws DataStoreException, IOException {
        String previous = null;
        Optional<Resource.FileSet> files = this.getFileSet();
        if (files.isPresent()) {
            for (Path path : files.get().getPaths()) {
                String base = URIDataStore.getBaseFilename(path);
                if (base.equals(previous)) continue;
                previous = base;
                path = path.resolveSibling(base.concat(extension));
                Files.deleteIfExists(path);
            }
        }
    }

    static String getBaseFilename(Path path) {
        String base = path.getFileName().toString();
        int s = base.lastIndexOf(46);
        return s >= 0 ? base.substring(0, s + 1) : base + ".";
    }

    protected final String cannotReadAuxiliaryFile(String extension) {
        if (extension == null) {
            return Errors.forLocale((Locale)this.getLocale()).getString((short)19, (Object)this.location);
        }
        return Resources.forLocale(this.getLocale()).getString((short)66, extension);
    }

    protected final void cannotReadAuxiliaryFile(Class<? extends DataStore> classe, String method, String extension, Exception cause, boolean warning) {
        LogRecord record = Resources.forLocale(this.getLocale()).createLogRecord(warning ? Level.WARNING : Level.FINE, (short)66, extension);
        record.setSourceClassName(classe.getCanonicalName());
        record.setSourceMethodName(method);
        record.setThrown(cause);
        this.listeners.warning(record);
    }
}

