/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.io.stream;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.ReadableByteChannel;
import javax.imageio.stream.IIOByteBuffer;
import javax.imageio.stream.ImageInputStream;
import org.apache.sis.io.stream.ChannelDataInput;

public class ChannelImageInputStream
extends ChannelDataInput
implements ImageInputStream {
    public ChannelImageInputStream(String filename, ReadableByteChannel channel, ByteBuffer buffer, boolean filled) throws IOException {
        super(filename, channel, buffer, filled);
    }

    public ChannelImageInputStream(String filename, ByteBuffer data) {
        super(filename, data);
    }

    public ChannelImageInputStream(ChannelDataInput input) {
        super(input);
    }

    @Override
    public final void setByteOrder(ByteOrder byteOrder) {
        this.buffer.order(byteOrder);
    }

    @Override
    public final ByteOrder getByteOrder() {
        return this.buffer.order();
    }

    @Override
    public final int read() throws IOException {
        return this.hasRemaining() ? Byte.toUnsignedInt(this.buffer.get()) : -1;
    }

    @Override
    public final int read(byte[] dest) throws IOException {
        return this.read(dest, 0, dest.length);
    }

    @Override
    public final int read(byte[] dest, int offset, int length) throws IOException {
        if (!this.hasRemaining()) {
            return -1;
        }
        int requested = length;
        while (length != 0 && this.hasRemaining()) {
            int n = Math.min(this.buffer.remaining(), length);
            this.buffer.get(dest, offset, n);
            offset += n;
            length -= n;
        }
        return requested - length;
    }

    @Override
    public final void readBytes(IIOByteBuffer dest, int length) throws IOException {
        int offset;
        byte[] data;
        this.bitPosition = 0L;
        if (this.buffer.hasArray()) {
            this.ensureBufferContains(1);
            data = this.buffer.array();
            offset = this.buffer.position();
            length = Math.min(this.buffer.remaining(), length);
            this.buffer.position(offset + length);
        } else {
            data = new byte[length];
            length = this.read(data);
            offset = 0;
        }
        dest.setData(data);
        dest.setOffset(offset);
        dest.setLength(length);
    }

    @Override
    public final int skipBytes(int n) throws IOException {
        if (n != 0) {
            long p = this.buffer.position() + n;
            if (p >= 0L && p <= (long)this.buffer.limit()) {
                this.buffer.position((int)p);
                this.bitPosition = 0L;
            } else {
                long offset = this.getStreamPosition();
                p = Math.max(Math.addExact(offset, (long)n), 0L);
                long length = this.length();
                if (length >= offset && p > length) {
                    p = length;
                }
                n = Math.toIntExact(p - offset);
                this.seek(p);
            }
        }
        return n;
    }

    @Override
    public final long skipBytes(long n) throws IOException {
        return this.skipBytes((int)Math.min(n, Integer.MAX_VALUE));
    }

    @Override
    public final void flush() throws IOException {
        this.flushBefore(this.getStreamPosition());
    }

    @Override
    public final boolean isCached() {
        return this.isCachedMemory();
    }

    @Override
    public final boolean isCachedMemory() {
        return false;
    }

    @Override
    public final boolean isCachedFile() {
        return false;
    }

    @Override
    public final void close() throws IOException {
        this.channel.close();
    }

    @Override
    final byte savedBitsForOutput(int bitOffset) {
        return (byte)(super.savedBitsForOutput(bitOffset) & ~((1 << 8 - bitOffset) - 1));
    }
}

